/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveStorageFormat;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public final class HiveSessionProperties {
    public static final String STORAGE_FORMAT_PROPERTY = "storage_format";
    private static final String OPTIMIZED_READER_ENABLED = "optimized_reader_enabled";

    private HiveSessionProperties() {
    }

    public static HiveStorageFormat getHiveStorageFormat(ConnectorSession session, HiveStorageFormat defaultValue) {
        String storageFormatString = (String)session.getProperties().get(STORAGE_FORMAT_PROPERTY);
        if (storageFormatString == null) {
            return defaultValue;
        }
        try {
            return HiveStorageFormat.valueOf(storageFormatString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Hive storage-format is invalid: " + storageFormatString);
        }
    }

    public static boolean isOptimizedReaderEnabled(ConnectorSession session, boolean defaultValue) {
        return HiveSessionProperties.isEnabled(OPTIMIZED_READER_ENABLED, session, defaultValue);
    }

    private static boolean isEnabled(String propertyName, ConnectorSession session, boolean defaultValue) {
        String enabled = (String)session.getProperties().get(propertyName);
        if (enabled == null) {
            return defaultValue;
        }
        return Boolean.valueOf(enabled);
    }
}

