/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.orc;

import com.facebook.hive.orc.OrcSerde;
import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.orc.OrcPageSourceFactory;
import com.facebook.presto.orc.metadata.DwrfMetadataReader;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.joda.time.DateTimeZone;

public class DwrfPageSourceFactory
implements HivePageSourceFactory {
    private final TypeManager typeManager;
    private final boolean enabled;

    @Inject
    public DwrfPageSourceFactory(TypeManager typeManager, HiveClientConfig config) {
        this(typeManager, config.isOptimizedReaderEnabled());
    }

    public DwrfPageSourceFactory(TypeManager typeManager) {
        this(typeManager, true);
    }

    public DwrfPageSourceFactory(TypeManager typeManager, boolean enabled) {
        this.typeManager = (TypeManager)Preconditions.checkNotNull((Object)typeManager, (Object)"typeManager is null");
        this.enabled = enabled;
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, Properties schema, List<HiveColumnHandle> columns, List<HivePartitionKey> partitionKeys, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone) {
        if (!HiveSessionProperties.isOptimizedReaderEnabled(session, this.enabled)) {
            return Optional.absent();
        }
        Deserializer deserializer = HiveUtil.getDeserializer(schema);
        if (!(deserializer instanceof OrcSerde)) {
            return Optional.absent();
        }
        return Optional.of((Object)OrcPageSourceFactory.createOrcPageSource((MetadataReader)new DwrfMetadataReader(), configuration, session, path, start, length, columns, partitionKeys, effectivePredicate, hiveStorageTimeZone, this.typeManager));
    }
}

