/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.client;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceSelectorConfig;
import io.airlift.discovery.client.ServiceSelectorFactory;
import io.airlift.discovery.client.ServiceTypes;
import java.lang.annotation.Annotation;

public class ServiceSelectorProvider
implements Provider<ServiceSelector> {
    private final String type;
    private ServiceSelectorFactory serviceSelectorFactory;
    private Injector injector;

    public ServiceSelectorProvider(String type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.type = type;
    }

    @Inject
    public void setInjector(Injector injector) {
        Preconditions.checkNotNull((Object)injector, (Object)"injector is null");
        this.injector = injector;
    }

    @Inject
    public void setServiceSelectorFactory(ServiceSelectorFactory serviceSelectorFactory) {
        Preconditions.checkNotNull((Object)serviceSelectorFactory, (Object)"serviceSelectorFactory is null");
        this.serviceSelectorFactory = serviceSelectorFactory;
    }

    public ServiceSelector get() {
        Preconditions.checkNotNull((Object)this.serviceSelectorFactory, (Object)"serviceSelectorFactory is null");
        Preconditions.checkNotNull((Object)this.injector, (Object)"injector is null");
        ServiceSelectorConfig selectorConfig = (ServiceSelectorConfig)this.injector.getInstance(Key.get(ServiceSelectorConfig.class, (Annotation)ServiceTypes.serviceType(this.type)));
        ServiceSelector serviceSelector = this.serviceSelectorFactory.createServiceSelector(this.type, selectorConfig);
        return serviceSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceSelectorProvider that = (ServiceSelectorProvider)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

