/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.apache.commons.configuration;

import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.Configuration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.ConfigurationException;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.HierarchicalConfiguration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.SubnodeConfiguration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.XMLConfiguration;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.event.ConfigurationEvent;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.event.ConfigurationListener;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.ConfigurationNode;
import com.facebook.presto.hadoop.shaded.org.apache.commons.configuration.tree.ExpressionEngine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MultiFileHierarchicalConfiguration
extends AbstractHierarchicalFileConfiguration
implements ConfigurationListener,
ConfigurationErrorListener {
    private static final String FILE_URL_PREFIX = "file:";
    private static ThreadLocal recursive = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private final Map configurationsMap = new HashMap();
    private String pattern;
    private boolean init;

    public MultiFileHierarchicalConfiguration() {
        this.init = true;
    }

    public MultiFileHierarchicalConfiguration(String pathPattern) {
        this.pattern = pathPattern;
        this.init = true;
    }

    public void setFilePattern(String pathPattern) {
        this.pattern = pathPattern;
    }

    protected AbstractHierarchicalFileConfiguration.FileConfigurationDelegate createDelegate() {
        return new AbstractHierarchicalFileConfiguration.FileConfigurationDelegate();
    }

    public void addProperty(String key, Object value) {
        this.getConfiguration().addProperty(key, value);
    }

    public void clear() {
        this.getConfiguration().clear();
    }

    public void clearProperty(String key) {
        this.getConfiguration().clearProperty(key);
    }

    public boolean containsKey(String key) {
        return this.getConfiguration().containsKey(key);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.getConfiguration().getBigDecimal(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getConfiguration().getBigDecimal(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.getConfiguration().getBigInteger(key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.getConfiguration().getBigInteger(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getConfiguration().getBoolean(key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getConfiguration().getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.getConfiguration().getBoolean(key);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.getConfiguration().getByte(key, defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.getConfiguration().getByte(key, defaultValue);
    }

    public byte getByte(String key) {
        return this.getConfiguration().getByte(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getConfiguration().getDouble(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.getConfiguration().getDouble(key, defaultValue);
    }

    public double getDouble(String key) {
        return this.getConfiguration().getDouble(key);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getConfiguration().getFloat(key, defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.getConfiguration().getFloat(key, defaultValue);
    }

    public float getFloat(String key) {
        return this.getConfiguration().getFloat(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.getConfiguration().getInt(key, defaultValue);
    }

    public int getInt(String key) {
        return this.getConfiguration().getInt(key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.getConfiguration().getInteger(key, defaultValue);
    }

    public Iterator getKeys() {
        return this.getConfiguration().getKeys();
    }

    public Iterator getKeys(String prefix) {
        return this.getConfiguration().getKeys(prefix);
    }

    public List getList(String key, List defaultValue) {
        return this.getConfiguration().getList(key, defaultValue);
    }

    public List getList(String key) {
        return this.getConfiguration().getList(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.getConfiguration().getLong(key, defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.getConfiguration().getLong(key, defaultValue);
    }

    public long getLong(String key) {
        return this.getConfiguration().getLong(key);
    }

    public Properties getProperties(String key) {
        return this.getConfiguration().getProperties(key);
    }

    public Object getProperty(String key) {
        return this.getConfiguration().getProperty(key);
    }

    public short getShort(String key, short defaultValue) {
        return this.getConfiguration().getShort(key, defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.getConfiguration().getShort(key, defaultValue);
    }

    public short getShort(String key) {
        return this.getConfiguration().getShort(key);
    }

    public String getString(String key, String defaultValue) {
        return this.getConfiguration().getString(key, defaultValue);
    }

    public String getString(String key) {
        return this.getConfiguration().getString(key);
    }

    public String[] getStringArray(String key) {
        return this.getConfiguration().getStringArray(key);
    }

    public boolean isEmpty() {
        return this.getConfiguration().isEmpty();
    }

    public void setProperty(String key, Object value) {
        if (this.init) {
            this.getConfiguration().setProperty(key, value);
        }
    }

    public Configuration subset(String prefix) {
        return this.getConfiguration().subset(prefix);
    }

    public HierarchicalConfiguration.Node getRoot() {
        return this.getConfiguration().getRoot();
    }

    public void setRoot(HierarchicalConfiguration.Node node) {
        if (this.init) {
            this.getConfiguration().setRoot(node);
        } else {
            super.setRoot(node);
        }
    }

    public ConfigurationNode getRootNode() {
        return this.getConfiguration().getRootNode();
    }

    public void setRootNode(ConfigurationNode rootNode) {
        if (this.init) {
            this.getConfiguration().setRootNode(rootNode);
        } else {
            super.setRootNode(rootNode);
        }
    }

    public ExpressionEngine getExpressionEngine() {
        return super.getExpressionEngine();
    }

    public void setExpressionEngine(ExpressionEngine expressionEngine) {
        super.setExpressionEngine(expressionEngine);
    }

    public void addNodes(String key, Collection nodes) {
        this.getConfiguration().addNodes(key, nodes);
    }

    public SubnodeConfiguration configurationAt(String key, boolean supportUpdates) {
        return this.getConfiguration().configurationAt(key, supportUpdates);
    }

    public SubnodeConfiguration configurationAt(String key) {
        return this.getConfiguration().configurationAt(key);
    }

    public List configurationsAt(String key) {
        return this.getConfiguration().configurationsAt(key);
    }

    public void clearTree(String key) {
        this.getConfiguration().clearTree(key);
    }

    public int getMaxIndex(String key) {
        return this.getConfiguration().getMaxIndex(key);
    }

    public Configuration interpolatedConfiguration() {
        return this.getConfiguration().interpolatedConfiguration();
    }

    public void addConfigurationListener(ConfigurationListener l) {
        super.addConfigurationListener(l);
    }

    public boolean removeConfigurationListener(ConfigurationListener l) {
        return super.removeConfigurationListener(l);
    }

    public Collection getConfigurationListeners() {
        return super.getConfigurationListeners();
    }

    public void clearConfigurationListeners() {
        super.clearConfigurationListeners();
    }

    public void addErrorListener(ConfigurationErrorListener l) {
        super.addErrorListener(l);
    }

    public boolean removeErrorListener(ConfigurationErrorListener l) {
        return super.removeErrorListener(l);
    }

    public void clearErrorListeners() {
        super.clearErrorListeners();
    }

    public Collection getErrorListeners() {
        return super.getErrorListeners();
    }

    public void save(Writer writer) throws ConfigurationException {
        if (this.init) {
            this.getConfiguration().save(writer);
        }
    }

    public void load(Reader reader) throws ConfigurationException {
        if (this.init) {
            this.getConfiguration().load(reader);
        }
    }

    public void load() throws ConfigurationException {
        this.getConfiguration().load();
    }

    public void load(String fileName) throws ConfigurationException {
        this.getConfiguration().load(fileName);
    }

    public void load(File file) throws ConfigurationException {
        this.getConfiguration().load(file);
    }

    public void load(URL url) throws ConfigurationException {
        this.getConfiguration().load(url);
    }

    public void load(InputStream in) throws ConfigurationException {
        this.getConfiguration().load(in);
    }

    public void load(InputStream in, String encoding) throws ConfigurationException {
        this.getConfiguration().load(in, encoding);
    }

    public void save() throws ConfigurationException {
        this.getConfiguration().save();
    }

    public void save(String fileName) throws ConfigurationException {
        this.getConfiguration().save(fileName);
    }

    public void save(File file) throws ConfigurationException {
        this.getConfiguration().save(file);
    }

    public void save(URL url) throws ConfigurationException {
        this.getConfiguration().save(url);
    }

    public void save(OutputStream out) throws ConfigurationException {
        this.getConfiguration().save(out);
    }

    public void save(OutputStream out, String encoding) throws ConfigurationException {
        this.getConfiguration().save(out, encoding);
    }

    public void configurationChanged(ConfigurationEvent event) {
        if (event.getSource() instanceof XMLConfiguration) {
            Iterator iter = this.getConfigurationListeners().iterator();
            while (iter.hasNext()) {
                ConfigurationListener listener = (ConfigurationListener)iter.next();
                listener.configurationChanged(event);
            }
        }
    }

    public void configurationError(ConfigurationErrorEvent event) {
        if (event.getSource() instanceof XMLConfiguration) {
            Iterator iter = this.getErrorListeners().iterator();
            while (iter.hasNext()) {
                ConfigurationErrorListener listener = (ConfigurationErrorListener)iter.next();
                listener.configurationError(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object resolveContainerStore(String key) {
        if (((Boolean)recursive.get()).booleanValue()) {
            return null;
        }
        recursive.set(Boolean.TRUE);
        try {
            Object object = super.resolveContainerStore(key);
            return object;
        }
        finally {
            recursive.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfiguration() {
        String path = this.getSubstitutor().replace(this.pattern);
        Map map = this.configurationsMap;
        synchronized (map) {
            this.configurationsMap.remove(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractHierarchicalFileConfiguration getConfiguration() {
        XMLConfiguration configuration;
        if (this.pattern == null) {
            throw new ConfigurationRuntimeException("File pattern must be defined");
        }
        String path = this.getSubstitutor().replace(this.pattern);
        Map map = this.configurationsMap;
        synchronized (map) {
            if (this.configurationsMap.containsKey(path)) {
                return (AbstractHierarchicalFileConfiguration)this.configurationsMap.get(path);
            }
        }
        if (path.equals(this.pattern)) {
            configuration = new XMLConfiguration(){

                public void load() throws ConfigurationException {
                }

                public void save() throws ConfigurationException {
                }
            };
            Map map2 = this.configurationsMap;
            synchronized (map2) {
                this.configurationsMap.put(this.pattern, configuration);
            }
            return configuration;
        }
        configuration = new XMLConfiguration();
        try {
            URL url = this.getURL(path);
            configuration.setURL(url);
            configuration.load();
            configuration.setExpressionEngine(this.getExpressionEngine());
            configuration.setReloadingStrategy(this.getReloadingStrategy());
            configuration.addConfigurationListener(this);
            configuration.addErrorListener(this);
            Map map3 = this.configurationsMap;
            synchronized (map3) {
                if (!this.configurationsMap.containsKey(path)) {
                    this.configurationsMap.put(path, configuration);
                }
            }
        }
        catch (ConfigurationException ce) {
            throw new ConfigurationRuntimeException(ce);
        }
        catch (FileNotFoundException fnfe) {
            throw new ConfigurationRuntimeException(fnfe);
        }
        return configuration;
    }

    private URL getURL(String resourceLocation) throws FileNotFoundException {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("A path pattern must be configured");
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new URL(FILE_URL_PREFIX + resourceLocation);
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is not a URL or a well-formed file path");
            }
        }
    }
}

