/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.facebook.presto.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
public class DelegationTokenRenewer
extends Thread {
    private static final Log LOG = LogFactory.getLog(DelegationTokenRenewer.class);
    private static final int RENEW_CYCLE = 82080000;
    @InterfaceAudience.Private
    protected static int renewCycle = 82080000;
    private volatile DelayQueue<RenewAction<?>> queue = new DelayQueue();
    private static DelegationTokenRenewer INSTANCE = null;

    @VisibleForTesting
    protected int getRenewQueueLength() {
        return this.queue.size();
    }

    private DelegationTokenRenewer(Class<? extends FileSystem> clazz) {
        super(clazz.getSimpleName() + "-" + DelegationTokenRenewer.class.getSimpleName());
        this.setDaemon(true);
    }

    public static synchronized DelegationTokenRenewer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DelegationTokenRenewer(FileSystem.class);
        }
        return INSTANCE;
    }

    public synchronized <T extends FileSystem> void addRenewAction(T fs) {
        this.queue.add(new RenewAction(fs, null));
        if (!this.isAlive()) {
            this.start();
        }
    }

    public synchronized <T extends FileSystem> void removeRenewAction(T fs) throws IOException {
        for (RenewAction<?> action : this.queue) {
            block3: {
                if (((RenewAction)action).weakFs.get() != fs) continue;
                try {
                    ((Renewable)((Object)fs)).getRenewToken().cancel(fs.getConf());
                }
                catch (InterruptedException ie) {
                    LOG.error("Interrupted while canceling token for " + fs.getUri() + "filesystem");
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug(ie.getStackTrace());
                }
            }
            this.queue.remove(action);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            RenewAction action = null;
            try {
                DelegationTokenRenewer delegationTokenRenewer = this;
                synchronized (delegationTokenRenewer) {
                    action = (RenewAction)this.queue.take();
                    if (action.renew()) {
                        action.updateRenewalTime();
                        this.queue.add(action);
                    }
                    continue;
                }
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (Exception ie) {
                FileSystem cfr_ignored_0 = (FileSystem)action.weakFs.get();
                FileSystem.LOG.warn("Failed to renew token, action=" + action, ie);
                continue;
            }
            break;
        }
    }

    static class 1 {
    }

    private static class RenewAction<T extends FileSystem>
    implements Delayed {
        private long renewalTime;
        private final WeakReference<T> weakFs;

        private RenewAction(T fs) {
            this.weakFs = new WeakReference<T>(fs);
            this.updateRenewalTime();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long millisLeft = this.renewalTime - Time.now();
            return unit.convert(millisLeft, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            RenewAction that = (RenewAction)delayed;
            return this.renewalTime < that.renewalTime ? -1 : (this.renewalTime == that.renewalTime ? 0 : 1);
        }

        public int hashCode() {
            return (int)this.renewalTime ^ (int)(this.renewalTime >>> 32);
        }

        public boolean equals(Object that) {
            if (that == null || !(that instanceof RenewAction)) {
                return false;
            }
            return this.compareTo((Delayed)that) == 0;
        }

        private void updateRenewalTime() {
            this.renewalTime = (long)renewCycle + Time.now();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean renew() throws IOException, InterruptedException {
            boolean b;
            FileSystem fs = (FileSystem)this.weakFs.get();
            boolean bl = b = fs != null;
            if (b) {
                FileSystem fileSystem = fs;
                synchronized (fileSystem) {
                    try {
                        ((Renewable)((Object)fs)).getRenewToken().renew(fs.getConf());
                    }
                    catch (IOException ie) {
                        try {
                            Token<?>[] tokens = fs.addDelegationTokens(null, null);
                            if (tokens.length == 0) {
                                throw new IOException("addDelegationTokens returned no tokens");
                            }
                            ((Renewable)((Object)fs)).setDelegationToken(tokens[0]);
                        }
                        catch (IOException ie2) {
                            throw new IOException("Can't renew or get new delegation token ", ie);
                        }
                    }
                }
            }
            return b;
        }

        public String toString() {
            Renewable fs = (Renewable)this.weakFs.get();
            return fs == null ? "evaporated token renew" : "The token will be renewed in " + this.getDelay(TimeUnit.SECONDS) + " secs, renewToken=" + fs.getRenewToken();
        }

        /* synthetic */ RenewAction(FileSystem x0, 1 x1) {
            this(x0);
        }
    }

    public static interface Renewable {
        public Token<?> getRenewToken();

        public <T extends TokenIdentifier> void setDelegationToken(Token<T> var1);
    }
}

