/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3.Block;
import org.apache.hadoop.fs.s3.FileSystemStore;
import org.apache.hadoop.fs.s3.INode;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class S3OutputStream
extends OutputStream {
    private Configuration conf;
    private int bufferSize;
    private FileSystemStore store;
    private Path path;
    private long blockSize;
    private File backupFile;
    private OutputStream backupStream;
    private Random r = new Random();
    private boolean closed;
    private int pos = 0;
    private long filePos = 0L;
    private int bytesWrittenToBlock = 0;
    private byte[] outBuf;
    private List<Block> blocks = new ArrayList<Block>();
    private Block nextBlock;
    private static final Log LOG = LogFactory.getLog(S3OutputStream.class.getName());

    public S3OutputStream(Configuration conf, FileSystemStore store, Path path, long blockSize, Progressable progress, int buffersize) throws IOException {
        this.conf = conf;
        this.store = store;
        this.path = path;
        this.blockSize = blockSize;
        this.backupFile = this.newBackupFile();
        this.backupStream = new FileOutputStream(this.backupFile);
        this.bufferSize = buffersize;
        this.outBuf = new byte[this.bufferSize];
    }

    private File newBackupFile() throws IOException {
        File dir = new File(this.conf.get("fs.s3.buffer.dir"));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create S3 buffer directory: " + dir);
        }
        File result = File.createTempFile("output-", ".tmp", dir);
        result.deleteOnExit();
        return result;
    }

    public long getPos() throws IOException {
        return this.filePos;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if ((long)(this.bytesWrittenToBlock + this.pos) == this.blockSize || this.pos >= this.bufferSize) {
            this.flush();
        }
        this.outBuf[this.pos++] = (byte)b;
        ++this.filePos;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        while (len > 0) {
            int remaining = this.bufferSize - this.pos;
            int toWrite = Math.min(remaining, len);
            System.arraycopy(b, off, this.outBuf, this.pos, toWrite);
            this.pos += toWrite;
            off += toWrite;
            len -= toWrite;
            this.filePos += (long)toWrite;
            if ((long)(this.bytesWrittenToBlock + this.pos) < this.blockSize && this.pos != this.bufferSize) continue;
            this.flush();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if ((long)(this.bytesWrittenToBlock + this.pos) >= this.blockSize) {
            this.flushData((int)this.blockSize - this.bytesWrittenToBlock);
        }
        if ((long)this.bytesWrittenToBlock == this.blockSize) {
            this.endBlock();
        }
        this.flushData(this.pos);
    }

    private synchronized void flushData(int maxPos) throws IOException {
        int workingPos = Math.min(this.pos, maxPos);
        if (workingPos > 0) {
            this.backupStream.write(this.outBuf, 0, workingPos);
            this.bytesWrittenToBlock += workingPos;
            System.arraycopy(this.outBuf, workingPos, this.outBuf, 0, this.pos - workingPos);
            this.pos -= workingPos;
        }
    }

    private synchronized void endBlock() throws IOException {
        this.backupStream.close();
        this.nextBlockOutputStream();
        this.store.storeBlock(this.nextBlock, this.backupFile);
        this.internalClose();
        boolean b = this.backupFile.delete();
        if (!b) {
            LOG.warn("Ignoring failed delete");
        }
        this.backupFile = this.newBackupFile();
        this.backupStream = new FileOutputStream(this.backupFile);
        this.bytesWrittenToBlock = 0;
    }

    private synchronized void nextBlockOutputStream() throws IOException {
        long blockId = this.r.nextLong();
        while (this.store.blockExists(blockId)) {
            blockId = this.r.nextLong();
        }
        this.nextBlock = new Block(blockId, this.bytesWrittenToBlock);
        this.blocks.add(this.nextBlock);
        this.bytesWrittenToBlock = 0;
    }

    private synchronized void internalClose() throws IOException {
        INode inode = new INode(INode.FileType.FILE, this.blocks.toArray(new Block[this.blocks.size()]));
        this.store.storeINode(this.path, inode);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flush();
        if (this.filePos == 0L || this.bytesWrittenToBlock != 0) {
            this.endBlock();
        }
        this.backupStream.close();
        boolean b = this.backupFile.delete();
        if (!b) {
            LOG.warn("Ignoring failed delete");
        }
        super.close();
        this.closed = true;
    }
}

