/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.facebook.presto.hadoop.shaded.com.google.protobuf.ByteString;
import com.facebook.presto.hadoop.shaded.com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientNamenodeProtocolTranslatorPB
implements ProtocolMetaInterface,
ClientProtocol,
Closeable,
ProtocolTranslator {
    private final ClientNamenodeProtocolPB rpcProxy;

    public ClientNamenodeProtocolTranslatorPB(ClientNamenodeProtocolPB proxy) throws IOException {
        this.rpcProxy = proxy;
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto req = ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto.newBuilder().setSrc(src).setOffset(offset).setLength(length).build();
        try {
            ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto resp = this.rpcProxy.getBlockLocations(null, req);
            return resp.hasLocations() ? PBHelper.convert(resp.getLocations()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto req = ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto.newBuilder().build();
        try {
            return PBHelper.convert(this.rpcProxy.getServerDefaults(null, req).getServerDefaults());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CreateRequestProto req = ClientNamenodeProtocolProtos.CreateRequestProto.newBuilder().setSrc(src).setMasked(PBHelper.convert(masked)).setClientName(clientName).setCreateFlag(PBHelper.convertCreateFlag(flag)).setCreateParent(createParent).setReplication(replication).setBlockSize(blockSize).build();
        try {
            this.rpcProxy.create(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public LocatedBlock append(String src, String clientName) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AppendRequestProto req = ClientNamenodeProtocolProtos.AppendRequestProto.newBuilder().setSrc(src).setClientName(clientName).build();
        try {
            ClientNamenodeProtocolProtos.AppendResponseProto res = this.rpcProxy.append(null, req);
            return res.hasBlock() ? PBHelper.convert(res.getBlock()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean setReplication(String src, short replication) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetReplicationRequestProto req = ClientNamenodeProtocolProtos.SetReplicationRequestProto.newBuilder().setSrc(src).setReplication(replication).build();
        try {
            return this.rpcProxy.setReplication(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetPermissionRequestProto req = ClientNamenodeProtocolProtos.SetPermissionRequestProto.newBuilder().setSrc(src).setPermission(PBHelper.convert(permission)).build();
        try {
            this.rpcProxy.setPermission(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetOwnerRequestProto.Builder req = ClientNamenodeProtocolProtos.SetOwnerRequestProto.newBuilder().setSrc(src);
        if (username != null) {
            req.setUsername(username);
        }
        if (groupname != null) {
            req.setGroupname(groupname);
        }
        try {
            this.rpcProxy.setOwner(null, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void abandonBlock(ExtendedBlock b, String src, String holder) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AbandonBlockRequestProto req = ClientNamenodeProtocolProtos.AbandonBlockRequestProto.newBuilder().setB(PBHelper.convert(b)).setSrc(src).setHolder(holder).build();
        try {
            this.rpcProxy.abandonBlock(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludeNodes) throws AccessControlException, FileNotFoundException, NotReplicatedYetException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AddBlockRequestProto.Builder req = ClientNamenodeProtocolProtos.AddBlockRequestProto.newBuilder().setSrc(src).setClientName(clientName);
        if (previous != null) {
            req.setPrevious(PBHelper.convert(previous));
        }
        if (excludeNodes != null) {
            req.addAllExcludeNodes(Arrays.asList(PBHelper.convert(excludeNodes)));
        }
        try {
            return PBHelper.convert(this.rpcProxy.addBlock(null, req.build()).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, ExtendedBlock blk, DatanodeInfo[] existings, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto req = ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto.newBuilder().setSrc(src).setBlk(PBHelper.convert(blk)).addAllExistings(Arrays.asList(PBHelper.convert(existings))).addAllExcludes(Arrays.asList(PBHelper.convert(excludes))).setNumAdditionalNodes(numAdditionalNodes).setClientName(clientName).build();
        try {
            return PBHelper.convert(this.rpcProxy.getAdditionalDatanode(null, req).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CompleteRequestProto.Builder req = ClientNamenodeProtocolProtos.CompleteRequestProto.newBuilder().setSrc(src).setClientName(clientName);
        if (last != null) {
            req.setLast(PBHelper.convert(last));
        }
        try {
            return this.rpcProxy.complete(null, req.build()).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto req = ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto.newBuilder().addAllBlocks(Arrays.asList(PBHelper.convertLocatedBlock(blocks))).build();
        try {
            this.rpcProxy.reportBadBlocks(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean rename(String src, String dst) throws UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.RenameRequestProto req = ClientNamenodeProtocolProtos.RenameRequestProto.newBuilder().setSrc(src).setDst(dst).build();
        try {
            return this.rpcProxy.rename(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws AccessControlException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        boolean overwrite = false;
        if (options != null) {
            for (Options.Rename option : options) {
                if (option != Options.Rename.OVERWRITE) continue;
                overwrite = true;
            }
        }
        ClientNamenodeProtocolProtos.Rename2RequestProto req = ClientNamenodeProtocolProtos.Rename2RequestProto.newBuilder().setSrc(src).setDst(dst).setOverwriteDest(overwrite).build();
        try {
            this.rpcProxy.rename2(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void concat(String trg, String[] srcs) throws IOException, UnresolvedLinkException {
        ClientNamenodeProtocolProtos.ConcatRequestProto req = ClientNamenodeProtocolProtos.ConcatRequestProto.newBuilder().setTrg(trg).addAllSrcs(Arrays.asList(srcs)).build();
        try {
            this.rpcProxy.concat(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean delete(String src, boolean recursive) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.DeleteRequestProto req = ClientNamenodeProtocolProtos.DeleteRequestProto.newBuilder().setSrc(src).setRecursive(recursive).build();
        try {
            return this.rpcProxy.delete(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.MkdirsRequestProto req = ClientNamenodeProtocolProtos.MkdirsRequestProto.newBuilder().setSrc(src).setMasked(PBHelper.convert(masked)).setCreateParent(createParent).build();
        try {
            return this.rpcProxy.mkdirs(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetListingRequestProto req = ClientNamenodeProtocolProtos.GetListingRequestProto.newBuilder().setSrc(src).setStartAfter(ByteString.copyFrom(startAfter)).setNeedLocation(needLocation).build();
        try {
            ClientNamenodeProtocolProtos.GetListingResponseProto result = this.rpcProxy.getListing(null, req);
            if (result.hasDirList()) {
                return PBHelper.convert(result.getDirList());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void renewLease(String clientName) throws AccessControlException, IOException {
        ClientNamenodeProtocolProtos.RenewLeaseRequestProto req = ClientNamenodeProtocolProtos.RenewLeaseRequestProto.newBuilder().setClientName(clientName).build();
        try {
            this.rpcProxy.renewLease(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.RecoverLeaseRequestProto req = ClientNamenodeProtocolProtos.RecoverLeaseRequestProto.newBuilder().setSrc(src).setClientName(clientName).build();
        try {
            return this.rpcProxy.recoverLease(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long[] getStats() throws IOException {
        ClientNamenodeProtocolProtos.GetFsStatusRequestProto req = ClientNamenodeProtocolProtos.GetFsStatusRequestProto.newBuilder().build();
        try {
            return PBHelper.convert(this.rpcProxy.getFsStats(null, req));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto.newBuilder().setType(PBHelper.convert(type)).build();
        try {
            return PBHelper.convert(this.rpcProxy.getDatanodeReport(null, req).getDiList());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException, UnresolvedLinkException {
        ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto req = ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto.newBuilder().setFilename(filename).build();
        try {
            return this.rpcProxy.getPreferredBlockSize(null, req).getBsize();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        ClientNamenodeProtocolProtos.SetSafeModeRequestProto req = ClientNamenodeProtocolProtos.SetSafeModeRequestProto.newBuilder().setAction(PBHelper.convert(action)).setChecked(isChecked).build();
        try {
            return this.rpcProxy.setSafeMode(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void saveNamespace() throws AccessControlException, IOException {
        ClientNamenodeProtocolProtos.SaveNamespaceRequestProto req = ClientNamenodeProtocolProtos.SaveNamespaceRequestProto.newBuilder().build();
        try {
            this.rpcProxy.saveNamespace(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long rollEdits() throws AccessControlException, IOException {
        ClientNamenodeProtocolProtos.RollEditsRequestProto req = ClientNamenodeProtocolProtos.RollEditsRequestProto.getDefaultInstance();
        try {
            ClientNamenodeProtocolProtos.RollEditsResponseProto resp = this.rpcProxy.rollEdits(null, req);
            return resp.getNewSegmentTxId();
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException(se);
        }
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws AccessControlException, IOException {
        ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto req = ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto.newBuilder().setArg(arg).build();
        try {
            return this.rpcProxy.restoreFailedStorage(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void refreshNodes() throws IOException {
        ClientNamenodeProtocolProtos.RefreshNodesRequestProto req = ClientNamenodeProtocolProtos.RefreshNodesRequestProto.newBuilder().build();
        try {
            this.rpcProxy.refreshNodes(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto req = ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto.newBuilder().build();
        try {
            this.rpcProxy.finalizeUpgrade(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public UpgradeStatusReport distributedUpgradeProgress(HdfsConstants.UpgradeAction action) throws IOException {
        ClientNamenodeProtocolProtos.DistributedUpgradeProgressRequestProto req = ClientNamenodeProtocolProtos.DistributedUpgradeProgressRequestProto.newBuilder().setAction(PBHelper.convert(action)).build();
        try {
            ClientNamenodeProtocolProtos.DistributedUpgradeProgressResponseProto res = this.rpcProxy.distributedUpgradeProgress(null, req);
            return res.hasReport() ? PBHelper.convert(res.getReport()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.Builder req = ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.newBuilder().setPath(path);
        if (cookie != null) {
            req.setCookie(cookie);
        }
        try {
            return PBHelper.convert(this.rpcProxy.listCorruptFileBlocks(null, req.build()).getCorrupt());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void metaSave(String filename) throws IOException {
        ClientNamenodeProtocolProtos.MetaSaveRequestProto req = ClientNamenodeProtocolProtos.MetaSaveRequestProto.newBuilder().setFilename(filename).build();
        try {
            this.rpcProxy.metaSave(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetFileInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileInfoRequestProto.newBuilder().setSrc(src).build();
        try {
            ClientNamenodeProtocolProtos.GetFileInfoResponseProto res = this.rpcProxy.getFileInfo(null, req);
            return res.hasFs() ? PBHelper.convert(res.getFs()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws AccessControlException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto.newBuilder().setSrc(src).build();
        try {
            ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto result = this.rpcProxy.getFileLinkInfo(null, req);
            return result.hasFs() ? PBHelper.convert(this.rpcProxy.getFileLinkInfo(null, req).getFs()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public ContentSummary getContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetContentSummaryRequestProto req = ClientNamenodeProtocolProtos.GetContentSummaryRequestProto.newBuilder().setPath(path).build();
        try {
            return PBHelper.convert(this.rpcProxy.getContentSummary(null, req).getSummary());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long diskspaceQuota) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetQuotaRequestProto req = ClientNamenodeProtocolProtos.SetQuotaRequestProto.newBuilder().setPath(path).setNamespaceQuota(namespaceQuota).setDiskspaceQuota(diskspaceQuota).build();
        try {
            this.rpcProxy.setQuota(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void fsync(String src, String client) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.FsyncRequestProto req = ClientNamenodeProtocolProtos.FsyncRequestProto.newBuilder().setSrc(src).setClient(client).build();
        try {
            this.rpcProxy.fsync(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetTimesRequestProto req = ClientNamenodeProtocolProtos.SetTimesRequestProto.newBuilder().setSrc(src).setMtime(mtime).setAtime(atime).build();
        try {
            this.rpcProxy.setTimes(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerm, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CreateSymlinkRequestProto req = ClientNamenodeProtocolProtos.CreateSymlinkRequestProto.newBuilder().setTarget(target).setLink(link).setDirPerm(PBHelper.convert(dirPerm)).setCreateParent(createParent).build();
        try {
            this.rpcProxy.createSymlink(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public String getLinkTarget(String path) throws AccessControlException, FileNotFoundException, IOException {
        ClientNamenodeProtocolProtos.GetLinkTargetRequestProto req = ClientNamenodeProtocolProtos.GetLinkTargetRequestProto.newBuilder().setPath(path).build();
        try {
            return this.rpcProxy.getLinkTarget(null, req).getTargetPath();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto req = ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto.newBuilder().setBlock(PBHelper.convert(block)).setClientName(clientName).build();
        try {
            return PBHelper.convert(this.rpcProxy.updateBlockForPipeline(null, req).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes) throws IOException {
        ClientNamenodeProtocolProtos.UpdatePipelineRequestProto req = ClientNamenodeProtocolProtos.UpdatePipelineRequestProto.newBuilder().setClientName(clientName).setOldBlock(PBHelper.convert(oldBlock)).setNewBlock(PBHelper.convert(newBlock)).addAllNewNodes(Arrays.asList(PBHelper.convert(newNodes))).build();
        try {
            this.rpcProxy.updatePipeline(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        ClientNamenodeProtocolProtos.GetDelegationTokenRequestProto req = ClientNamenodeProtocolProtos.GetDelegationTokenRequestProto.newBuilder().setRenewer(renewer.toString()).build();
        try {
            return PBHelper.convertDelegationToken(this.rpcProxy.getDelegationToken(null, req).getToken());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        ClientNamenodeProtocolProtos.RenewDelegationTokenRequestProto req = ClientNamenodeProtocolProtos.RenewDelegationTokenRequestProto.newBuilder().setToken(PBHelper.convert(token)).build();
        try {
            return this.rpcProxy.renewDelegationToken(null, req).getNewExireTime();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        ClientNamenodeProtocolProtos.CancelDelegationTokenRequestProto req = ClientNamenodeProtocolProtos.CancelDelegationTokenRequestProto.newBuilder().setToken(PBHelper.convert(token)).build();
        try {
            this.rpcProxy.cancelDelegationToken(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto req = ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto.newBuilder().setBandwidth(bandwidth).build();
        try {
            this.rpcProxy.setBalancerBandwidth(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported(this.rpcProxy, ClientNamenodeProtocolPB.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RPC.getProtocolVersion(ClientNamenodeProtocolPB.class), methodName);
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto req = ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto.newBuilder().build();
        try {
            return PBHelper.convert(this.rpcProxy.getDataEncryptionKey(null, req).getDataEncryptionKey());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean isFileClosed(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.IsFileClosedRequestProto req = ClientNamenodeProtocolProtos.IsFileClosedRequestProto.newBuilder().setSrc(src).build();
        try {
            return this.rpcProxy.isFileClosed(null, req).getResult();
        }
        catch (ServiceException e) {
            IOException ioe = ProtobufHelper.getRemoteException(e);
            if (ioe.getMessage().startsWith("Unknown method isFileClosed called")) {
                throw new UnsupportedOperationException("Remote server does not implement isFileClosed.", ioe);
            }
            throw ioe;
        }
    }

    @Override
    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

