/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.facebook.presto.hadoop.shaded.com.google.protobuf.RpcController;
import com.facebook.presto.hadoop.shaded.com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.proto.JournalProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.JournalProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.server.protocol.JournalProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class JournalProtocolTranslatorPB
implements ProtocolMetaInterface,
JournalProtocol,
Closeable {
    private static final RpcController NULL_CONTROLLER = null;
    private final JournalProtocolPB rpcProxy;

    public JournalProtocolTranslatorPB(JournalProtocolPB rpcProxy) {
        this.rpcProxy = rpcProxy;
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public void journal(NamenodeRegistration reg, long firstTxnId, int numTxns, byte[] records) throws IOException {
        JournalProtocolProtos.JournalRequestProto req = JournalProtocolProtos.JournalRequestProto.newBuilder().setJournalInfo(PBHelper.convertToJournalInfo(reg)).setFirstTxnId(firstTxnId).setNumTxns(numTxns).setRecords(PBHelper.getByteString(records)).build();
        try {
            this.rpcProxy.journal(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void startLogSegment(NamenodeRegistration registration, long txid) throws IOException {
        JournalProtocolProtos.StartLogSegmentRequestProto req = JournalProtocolProtos.StartLogSegmentRequestProto.newBuilder().setJournalInfo(PBHelper.convertToJournalInfo(registration)).setTxid(txid).build();
        try {
            this.rpcProxy.startLogSegment(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported(this.rpcProxy, JournalProtocolPB.class, RPC.RpcKind.RPC_PROTOCOL_BUFFER, RPC.getProtocolVersion(JournalProtocolPB.class), methodName);
    }
}

