/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.servlet.ServletContext;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.qjournal.server.GetJournalEditServlet;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

@InterfaceAudience.Private
public class JournalNodeHttpServer {
    public static final Log LOG = LogFactory.getLog(JournalNodeHttpServer.class);
    public static final String JN_ATTRIBUTE_KEY = "localjournal";
    private HttpServer httpServer;
    private int infoPort;
    private JournalNode localJournalNode;
    private final Configuration conf;

    JournalNodeHttpServer(Configuration conf, JournalNode jn) {
        this.conf = conf;
        this.localJournalNode = jn;
    }

    void start() throws IOException {
        InetSocketAddress bindAddr = JournalNodeHttpServer.getAddress(this.conf);
        LOG.info("Starting web server as: " + SecurityUtil.getServerPrincipal(this.conf.get("dfs.journalnode.kerberos.internal.spnego.principal"), bindAddr.getHostName()));
        int tmpInfoPort = bindAddr.getPort();
        this.httpServer = new HttpServer("journal", bindAddr.getHostName(), tmpInfoPort, tmpInfoPort == 0, this.conf, new AccessControlList(this.conf.get("dfs.cluster.administrators", " "))){
            {
                if (UserGroupInformation.isSecurityEnabled()) {
                    this.initSpnego(JournalNodeHttpServer.this.conf, "dfs.journalnode.kerberos.internal.spnego.principal", "dfs.journalnode.keytab.file");
                }
            }
        };
        this.httpServer.setAttribute(JN_ATTRIBUTE_KEY, this.localJournalNode);
        this.httpServer.setAttribute("current.conf", this.conf);
        this.httpServer.addInternalServlet("getJournal", "/getJournal", GetJournalEditServlet.class, true);
        this.httpServer.start();
        this.infoPort = this.httpServer.getPort();
        LOG.info("Journal Web-server up at: " + bindAddr + ":" + this.infoPort);
    }

    void stop() throws IOException {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public InetSocketAddress getAddress() {
        InetSocketAddress addr = this.httpServer.getListenerAddress();
        assert (addr.getPort() != 0);
        return addr;
    }

    private static InetSocketAddress getAddress(Configuration conf) {
        String addr = conf.get("dfs.journalnode.http-address", "0.0.0.0:8480");
        return NetUtils.createSocketAddr(addr, 8480, "dfs.journalnode.http-address");
    }

    public static Journal getJournalFromContext(ServletContext context, String jid) throws IOException {
        JournalNode jn = (JournalNode)context.getAttribute(JN_ATTRIBUTE_KEY);
        return jn.getOrCreateJournal(jid);
    }

    public static Configuration getConfFromContext(ServletContext context) {
        return (Configuration)context.getAttribute("current.conf");
    }
}

