/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class FSImageCompression {
    private CompressionCodec imageCodec;

    private FSImageCompression() {
    }

    private FSImageCompression(CompressionCodec codec) {
        this.imageCodec = codec;
    }

    static FSImageCompression createNoopCompression() {
        return new FSImageCompression();
    }

    static FSImageCompression createCompression(Configuration conf) throws IOException {
        boolean compressImage = conf.getBoolean("dfs.image.compress", false);
        if (!compressImage) {
            return FSImageCompression.createNoopCompression();
        }
        String codecClassName = conf.get("dfs.image.compression.codec", "org.apache.hadoop.io.compress.DefaultCodec");
        return FSImageCompression.createCompression(conf, codecClassName);
    }

    private static FSImageCompression createCompression(Configuration conf, String codecClassName) throws IOException {
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        CompressionCodec codec = factory.getCodecByClassName(codecClassName);
        if (codec == null) {
            throw new IOException("Not a supported codec: " + codecClassName);
        }
        return new FSImageCompression(codec);
    }

    static FSImageCompression readCompressionHeader(Configuration conf, DataInputStream dis) throws IOException {
        boolean isCompressed = dis.readBoolean();
        if (!isCompressed) {
            return FSImageCompression.createNoopCompression();
        }
        String codecClassName = Text.readString(dis);
        return FSImageCompression.createCompression(conf, codecClassName);
    }

    DataInputStream unwrapInputStream(InputStream is) throws IOException {
        if (this.imageCodec != null) {
            return new DataInputStream(this.imageCodec.createInputStream(is));
        }
        return new DataInputStream(new BufferedInputStream(is));
    }

    DataOutputStream writeHeaderAndWrapStream(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeBoolean(this.imageCodec != null);
        if (this.imageCodec != null) {
            String codecClassName = this.imageCodec.getClass().getCanonicalName();
            Text.writeString(dos, codecClassName);
            return new DataOutputStream(this.imageCodec.createOutputStream(os));
        }
        return new DataOutputStream(new BufferedOutputStream(os));
    }

    public String toString() {
        if (this.imageCodec != null) {
            return "codec " + this.imageCodec.getClass().getCanonicalName();
        }
        return "no compression";
    }
}

