/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.PrintStream;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.util.GSet;

@InterfaceAudience.Private
public class LightWeightGSet<K, E extends K>
implements GSet<K, E> {
    public static final Log LOG = LogFactory.getLog(GSet.class);
    static final int MAX_ARRAY_LENGTH = 0x40000000;
    static final int MIN_ARRAY_LENGTH = 1;
    private final LinkedElement[] entries;
    private final int hash_mask;
    private int size = 0;
    private int modification = 0;

    public LightWeightGSet(int recommended_length) {
        int actual = LightWeightGSet.actualArrayLength(recommended_length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("recommended=" + recommended_length + ", actual=" + actual);
        }
        this.entries = new LinkedElement[actual];
        this.hash_mask = this.entries.length - 1;
    }

    private static int actualArrayLength(int recommended) {
        if (recommended > 0x40000000) {
            return 0x40000000;
        }
        if (recommended < 1) {
            return 1;
        }
        int a = Integer.highestOneBit(recommended);
        return a == recommended ? a : a << 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    private int getIndex(K key) {
        return key.hashCode() & this.hash_mask;
    }

    private E convert(LinkedElement e) {
        LinkedElement r = e;
        return (E)r;
    }

    @Override
    public E get(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        int index = this.getIndex(key);
        for (LinkedElement e = this.entries[index]; e != null; e = e.getNext()) {
            if (!e.equals(key)) continue;
            return this.convert(e);
        }
        return null;
    }

    @Override
    public boolean contains(K key) {
        return this.get(key) != null;
    }

    @Override
    public E put(E element) {
        if (element == null) {
            throw new NullPointerException("Null element is not supported.");
        }
        if (!(element instanceof LinkedElement)) {
            throw new HadoopIllegalArgumentException("!(element instanceof LinkedElement), element.getClass()=" + element.getClass());
        }
        LinkedElement e = (LinkedElement)element;
        int index = this.getIndex(element);
        E existing = this.remove(index, element);
        ++this.modification;
        ++this.size;
        e.setNext(this.entries[index]);
        this.entries[index] = e;
        return existing;
    }

    private E remove(int index, K key) {
        if (this.entries[index] == null) {
            return null;
        }
        if (this.entries[index].equals(key)) {
            ++this.modification;
            --this.size;
            LinkedElement e = this.entries[index];
            this.entries[index] = e.getNext();
            e.setNext(null);
            return this.convert(e);
        }
        LinkedElement prev = this.entries[index];
        for (LinkedElement curr = prev.getNext(); curr != null; curr = curr.getNext()) {
            if (curr.equals(key)) {
                ++this.modification;
                --this.size;
                prev.setNext(curr.getNext());
                curr.setNext(null);
                return this.convert(curr);
            }
            prev = curr;
        }
        return null;
    }

    @Override
    public E remove(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.remove(this.getIndex(key), key);
    }

    @Override
    public Iterator<E> iterator() {
        return new SetIterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
        b.append("(size=").append(this.size).append(String.format(", %08x", this.hash_mask)).append(", modification=").append(this.modification).append(", entries.length=").append(this.entries.length).append(")");
        return b.toString();
    }

    public void printDetails(PrintStream out) {
        out.print(this + ", entries = [");
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            LinkedElement e = this.entries[i];
            out.print("\n  " + i + ": " + e);
            for (e = e.getNext(); e != null; e = e.getNext()) {
                out.print(" -> " + e);
            }
        }
        out.println("\n]");
    }

    private class SetIterator
    implements Iterator<E> {
        private final int startModification;
        private int index;
        private LinkedElement next;

        private SetIterator() {
            this.startModification = LightWeightGSet.this.modification;
            this.index = -1;
            this.next = this.nextNonemptyEntry();
        }

        private LinkedElement nextNonemptyEntry() {
            ++this.index;
            while (this.index < LightWeightGSet.this.entries.length && LightWeightGSet.this.entries[this.index] == null) {
                ++this.index;
            }
            return this.index < LightWeightGSet.this.entries.length ? LightWeightGSet.this.entries[this.index] : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (LightWeightGSet.this.modification != this.startModification) {
                throw new ConcurrentModificationException("modification=" + LightWeightGSet.this.modification + " != startModification = " + this.startModification);
            }
            Object e = LightWeightGSet.this.convert(this.next);
            LinkedElement n = this.next.getNext();
            this.next = n != null ? n : this.nextNonemptyEntry();
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }

    public static interface LinkedElement {
        public void setNext(LinkedElement var1);

        public LinkedElement getNext();
    }
}

