/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.util.NativeCodeLoader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NativeIO {
    public static final int O_RDONLY = 0;
    public static final int O_WRONLY = 1;
    public static final int O_RDWR = 2;
    public static final int O_CREAT = 64;
    public static final int O_EXCL = 128;
    public static final int O_NOCTTY = 256;
    public static final int O_TRUNC = 512;
    public static final int O_APPEND = 1024;
    public static final int O_NONBLOCK = 2048;
    public static final int O_SYNC = 4096;
    public static final int O_ASYNC = 8192;
    public static final int O_FSYNC = 4096;
    public static final int O_NDELAY = 2048;
    public static final int POSIX_FADV_NORMAL = 0;
    public static final int POSIX_FADV_RANDOM = 1;
    public static final int POSIX_FADV_SEQUENTIAL = 2;
    public static final int POSIX_FADV_WILLNEED = 3;
    public static final int POSIX_FADV_DONTNEED = 4;
    public static final int POSIX_FADV_NOREUSE = 5;
    public static final int SYNC_FILE_RANGE_WAIT_BEFORE = 1;
    public static final int SYNC_FILE_RANGE_WRITE = 2;
    public static final int SYNC_FILE_RANGE_WAIT_AFTER = 4;
    private static final Log LOG = LogFactory.getLog(NativeIO.class);
    private static boolean nativeLoaded = false;
    private static boolean workaroundNonThreadSafePasswdCalls = false;
    private static boolean fadvisePossible = true;
    private static boolean syncFileRangePossible = true;
    static final String WORKAROUND_NON_THREADSAFE_CALLS_KEY = "hadoop.workaround.non.threadsafe.getpwuid";
    static final boolean WORKAROUND_NON_THREADSAFE_CALLS_DEFAULT = false;
    private static long cacheTimeout = -1L;
    private static final Map<Integer, CachedName> USER_ID_NAME_CACHE;
    private static final Map<Integer, CachedName> GROUP_ID_NAME_CACHE;

    public static boolean isAvailable() {
        return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
    }

    public static native FileDescriptor open(String var0, int var1, int var2) throws IOException;

    private static native Stat fstat(FileDescriptor var0) throws IOException;

    public static native void chmod(String var0, int var1) throws IOException;

    static native void posix_fadvise(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

    static native void sync_file_range(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

    private static native void initNative();

    public static void posixFadviseIfPossible(FileDescriptor fd, long offset, long len, int flags) throws NativeIOException {
        if (nativeLoaded && fadvisePossible) {
            try {
                NativeIO.posix_fadvise(fd, offset, len, flags);
            }
            catch (UnsupportedOperationException uoe) {
                fadvisePossible = false;
            }
            catch (UnsatisfiedLinkError ule) {
                fadvisePossible = false;
            }
        }
    }

    public static void syncFileRangeIfPossible(FileDescriptor fd, long offset, long nbytes, int flags) throws NativeIOException {
        if (nativeLoaded && syncFileRangePossible) {
            try {
                NativeIO.sync_file_range(fd, offset, nbytes, flags);
            }
            catch (UnsupportedOperationException uoe) {
                syncFileRangePossible = false;
            }
            catch (UnsatisfiedLinkError ule) {
                syncFileRangePossible = false;
            }
        }
    }

    static native String getUserName(int var0) throws IOException;

    static native String getGroupName(int var0) throws IOException;

    private static String getName(IdCache domain, int id) throws IOException {
        String name;
        Map<Integer, CachedName> idNameCache = domain == IdCache.USER ? USER_ID_NAME_CACHE : GROUP_ID_NAME_CACHE;
        CachedName cachedName = idNameCache.get(id);
        long now = System.currentTimeMillis();
        if (cachedName != null && cachedName.timestamp + cacheTimeout > now) {
            name = cachedName.name;
        } else {
            String string = name = domain == IdCache.USER ? NativeIO.getUserName(id) : NativeIO.getGroupName(id);
            if (LOG.isDebugEnabled()) {
                String type = domain == IdCache.USER ? "UserName" : "GroupName";
                LOG.debug("Got " + type + " " + name + " for ID " + id + " from the native implementation");
            }
            cachedName = new CachedName(name, now);
            idNameCache.put(id, cachedName);
        }
        return name;
    }

    public static Stat getFstat(FileDescriptor fd) throws IOException {
        Stat stat = NativeIO.fstat(fd);
        stat.owner = NativeIO.getName(IdCache.USER, stat.ownerId);
        stat.group = NativeIO.getName(IdCache.GROUP, stat.groupId);
        return stat;
    }

    public static void renameTo(File src, File dst) throws IOException {
        if (!nativeLoaded) {
            if (!src.renameTo(dst)) {
                throw new IOException("renameTo(src=" + src + ", dst=" + dst + ") failed.");
            }
        } else {
            NativeIO.renameTo0(src.getAbsolutePath(), dst.getAbsolutePath());
        }
    }

    private static native void renameTo0(String var0, String var1) throws NativeIOException;

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                Configuration conf = new Configuration();
                workaroundNonThreadSafePasswdCalls = conf.getBoolean(WORKAROUND_NON_THREADSAFE_CALLS_KEY, false);
                NativeIO.initNative();
                nativeLoaded = true;
                cacheTimeout = conf.getLong("hadoop.security.uid.cache.secs", 14400L) * 1000L;
                LOG.debug("Initialized cache for IDs to User/Group mapping with a cache timeout of " + cacheTimeout / 1000L + " seconds.");
            }
            catch (Throwable t) {
                LOG.error("Unable to initialize NativeIO libraries", t);
            }
        }
        USER_ID_NAME_CACHE = new ConcurrentHashMap<Integer, CachedName>();
        GROUP_ID_NAME_CACHE = new ConcurrentHashMap<Integer, CachedName>();
    }

    private static enum IdCache {
        USER,
        GROUP;

    }

    private static class CachedName {
        final long timestamp;
        final String name;

        public CachedName(String name, long timestamp) {
            this.name = name;
            this.timestamp = timestamp;
        }
    }

    public static class Stat {
        private int ownerId;
        private int groupId;
        private String owner;
        private String group;
        private int mode;
        public static final int S_IFMT = 61440;
        public static final int S_IFIFO = 4096;
        public static final int S_IFCHR = 8192;
        public static final int S_IFDIR = 16384;
        public static final int S_IFBLK = 24576;
        public static final int S_IFREG = 32768;
        public static final int S_IFLNK = 40960;
        public static final int S_IFSOCK = 49152;
        public static final int S_IFWHT = 57344;
        public static final int S_ISUID = 2048;
        public static final int S_ISGID = 1024;
        public static final int S_ISVTX = 512;
        public static final int S_IRUSR = 256;
        public static final int S_IWUSR = 128;
        public static final int S_IXUSR = 64;

        Stat(int ownerId, int groupId, int mode) {
            this.ownerId = ownerId;
            this.groupId = groupId;
            this.mode = mode;
        }

        public String toString() {
            return "Stat(owner='" + this.owner + "', group='" + this.group + "'" + ", mode=" + this.mode + ")";
        }

        public String getOwner() {
            return this.owner;
        }

        public String getGroup() {
            return this.group;
        }

        public int getMode() {
            return this.mode;
        }
    }
}

