/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class IFileOutputStream
extends FilterOutputStream {
    private final DataChecksum sum = DataChecksum.newDataChecksum(1, Integer.MAX_VALUE);
    private byte[] barray = new byte[this.sum.getChecksumSize()];
    private boolean closed = false;
    private boolean finished = false;

    public IFileOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.sum.writeValue(this.barray, 0, false);
        this.out.write(this.barray, 0, this.sum.getChecksumSize());
        this.out.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.sum.update(b, off, len);
        this.out.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.barray[0] = (byte)(b & 0xFF);
        this.write(this.barray, 0, 1);
    }
}

