/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.protocol.ClientProtocolProvider;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.util.ConfigUtil;
import org.apache.hadoop.mapreduce.v2.LogParams;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class Cluster {
    private ClientProtocolProvider clientProtocolProvider;
    private ClientProtocol client;
    private UserGroupInformation ugi;
    private Configuration conf;
    private FileSystem fs = null;
    private Path sysDir = null;
    private Path stagingAreaDir = null;
    private Path jobHistoryDir = null;
    private static final Log LOG = LogFactory.getLog(Cluster.class);
    private static ServiceLoader<ClientProtocolProvider> frameworkLoader = ServiceLoader.load(ClientProtocolProvider.class);

    public Cluster(Configuration conf) throws IOException {
        this(null, conf);
    }

    public Cluster(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        this.conf = conf;
        this.ugi = UserGroupInformation.getCurrentUser();
        this.initialize(jobTrackAddr, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(InetSocketAddress jobTrackAddr, Configuration conf) throws IOException {
        ServiceLoader<ClientProtocolProvider> serviceLoader = frameworkLoader;
        synchronized (serviceLoader) {
            for (ClientProtocolProvider provider : frameworkLoader) {
                LOG.debug("Trying ClientProtocolProvider : " + provider.getClass().getName());
                ClientProtocol clientProtocol = null;
                try {
                    clientProtocol = jobTrackAddr == null ? provider.create(conf) : provider.create(jobTrackAddr, conf);
                    if (clientProtocol != null) {
                        this.clientProtocolProvider = provider;
                        this.client = clientProtocol;
                        LOG.debug("Picked " + provider.getClass().getName() + " as the ClientProtocolProvider");
                        break;
                    }
                    LOG.debug("Cannot pick " + provider.getClass().getName() + " as the ClientProtocolProvider - returned null protocol");
                }
                catch (Exception e) {
                    LOG.info("Failed to use " + provider.getClass().getName() + " due to error: " + e.getMessage());
                }
            }
        }
        if (null == this.clientProtocolProvider || null == this.client) {
            throw new IOException("Cannot initialize Cluster. Please check your configuration for mapreduce.framework.name and the correspond server addresses.");
        }
    }

    ClientProtocol getClient() {
        return this.client;
    }

    Configuration getConf() {
        return this.conf;
    }

    public synchronized void close() throws IOException {
        this.clientProtocolProvider.close(this.client);
    }

    private Job[] getJobs(JobStatus[] stats) throws IOException {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (JobStatus stat : stats) {
            jobs.add(Job.getInstance(this, stat, new JobConf(stat.getJobFile())));
        }
        return jobs.toArray(new Job[0]);
    }

    public synchronized FileSystem getFileSystem() throws IOException, InterruptedException {
        if (this.fs == null) {
            try {
                this.fs = this.ugi.doAs(new PrivilegedExceptionAction<FileSystem>(){

                    @Override
                    public FileSystem run() throws IOException, InterruptedException {
                        Path sysDir = new Path(Cluster.this.client.getSystemDir());
                        return sysDir.getFileSystem(Cluster.this.getConf());
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.fs;
    }

    public Job getJob(JobID jobId) throws IOException, InterruptedException {
        JobStatus status = this.client.getJobStatus(jobId);
        if (status != null) {
            return Job.getInstance(this, status, new JobConf(status.getJobFile()));
        }
        return null;
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        return this.client.getQueues();
    }

    public QueueInfo getQueue(String name) throws IOException, InterruptedException {
        return this.client.getQueue(name);
    }

    public LogParams getLogParams(JobID jobID, TaskAttemptID taskAttemptID) throws IOException, InterruptedException {
        return this.client.getLogFileParams(jobID, taskAttemptID);
    }

    public ClusterMetrics getClusterStatus() throws IOException, InterruptedException {
        return this.client.getClusterMetrics();
    }

    public TaskTrackerInfo[] getActiveTaskTrackers() throws IOException, InterruptedException {
        return this.client.getActiveTrackers();
    }

    public TaskTrackerInfo[] getBlackListedTaskTrackers() throws IOException, InterruptedException {
        return this.client.getBlacklistedTrackers();
    }

    @Deprecated
    public Job[] getAllJobs() throws IOException, InterruptedException {
        return this.getJobs(this.client.getAllJobs());
    }

    public JobStatus[] getAllJobStatuses() throws IOException, InterruptedException {
        return this.client.getAllJobs();
    }

    public Path getSystemDir() throws IOException, InterruptedException {
        if (this.sysDir == null) {
            this.sysDir = new Path(this.client.getSystemDir());
        }
        return this.sysDir;
    }

    public Path getStagingAreaDir() throws IOException, InterruptedException {
        if (this.stagingAreaDir == null) {
            this.stagingAreaDir = new Path(this.client.getStagingAreaDir());
        }
        return this.stagingAreaDir;
    }

    public String getJobHistoryUrl(JobID jobId) throws IOException, InterruptedException {
        if (this.jobHistoryDir == null) {
            this.jobHistoryDir = new Path(this.client.getJobHistoryDir());
        }
        return new Path(this.jobHistoryDir, jobId.toString() + "_" + this.ugi.getShortUserName()).toString();
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        return this.client.getQueueAclsForCurrentUser();
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        return this.client.getRootQueues();
    }

    public QueueInfo[] getChildQueues(String queueName) throws IOException, InterruptedException {
        return this.client.getChildQueues(queueName);
    }

    public JobTrackerStatus getJobTrackerStatus() throws IOException, InterruptedException {
        return this.client.getJobTrackerStatus();
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return this.client.getTaskTrackerExpiryInterval();
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return this.client.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException, InterruptedException {
        try {
            return this.client.renewDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        try {
            this.client.cancelDelegationToken(token);
        }
        catch (RemoteException re) {
            throw re.unwrapRemoteException(SecretManager.InvalidToken.class, AccessControlException.class);
        }
    }

    static {
        ConfigUtil.loadResources();
    }

    @InterfaceStability.Evolving
    public static enum JobTrackerStatus {
        INITIALIZING,
        RUNNING;

    }
}

