/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TaskAttemptID
extends org.apache.hadoop.mapred.ID {
    protected static final String ATTEMPT = "attempt";
    private TaskID taskId;

    public TaskAttemptID(TaskID taskId, int id) {
        super(id);
        if (taskId == null) {
            throw new IllegalArgumentException("taskId cannot be null");
        }
        this.taskId = taskId;
    }

    public TaskAttemptID(String jtIdentifier, int jobId, TaskType type, int taskId, int id) {
        this(new TaskID(jtIdentifier, jobId, type, taskId), id);
    }

    public TaskAttemptID() {
        this.taskId = new TaskID();
    }

    public JobID getJobID() {
        return this.taskId.getJobID();
    }

    public TaskID getTaskID() {
        return this.taskId;
    }

    @Deprecated
    public boolean isMap() {
        return this.taskId.isMap();
    }

    public TaskType getTaskType() {
        return this.taskId.getTaskType();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TaskAttemptID that = (TaskAttemptID)o;
        return this.taskId.equals(that.taskId);
    }

    protected StringBuilder appendTo(StringBuilder builder) {
        return this.taskId.appendTo(builder).append('_').append(this.id);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.taskId.readFields(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.taskId.write(out);
    }

    @Override
    public int hashCode() {
        return this.taskId.hashCode() * 5 + this.id;
    }

    @Override
    public int compareTo(ID o) {
        TaskAttemptID that = (TaskAttemptID)o;
        int tipComp = this.taskId.compareTo(that.taskId);
        if (tipComp == 0) {
            return this.id - that.id;
        }
        return tipComp;
    }

    @Override
    public String toString() {
        return this.appendTo(new StringBuilder(ATTEMPT)).toString();
    }

    public static TaskAttemptID forName(String str) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        String exceptionMsg = null;
        try {
            String[] parts = str.split(Character.toString('_'));
            if (parts.length == 6 && parts[0].equals(ATTEMPT)) {
                String type = parts[3];
                TaskType t = TaskID.getTaskType(type.charAt(0));
                if (t != null) {
                    return new org.apache.hadoop.mapred.TaskAttemptID(parts[1], Integer.parseInt(parts[2]), t, Integer.parseInt(parts[4]), Integer.parseInt(parts[5]));
                }
                exceptionMsg = "Bad TaskType identifier. TaskAttemptId string : " + str + " is not properly formed.";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (exceptionMsg == null) {
            exceptionMsg = "TaskAttemptId string : " + str + " is not properly formed";
        }
        throw new IllegalArgumentException(exceptionMsg);
    }
}

