/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ShuffleHeader
implements Writable {
    private static final int MAX_ID_LENGTH = 1000;
    String mapId;
    long uncompressedLength;
    long compressedLength;
    int forReduce;

    public ShuffleHeader() {
    }

    public ShuffleHeader(String mapId, long compressedLength, long uncompressedLength, int forReduce) {
        this.mapId = mapId;
        this.compressedLength = compressedLength;
        this.uncompressedLength = uncompressedLength;
        this.forReduce = forReduce;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.mapId = WritableUtils.readStringSafely(in, 1000);
        this.compressedLength = WritableUtils.readVLong(in);
        this.uncompressedLength = WritableUtils.readVLong(in);
        this.forReduce = WritableUtils.readVInt(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.mapId);
        WritableUtils.writeVLong(out, this.compressedLength);
        WritableUtils.writeVLong(out, this.uncompressedLength);
        WritableUtils.writeVInt(out, this.forReduce);
    }
}

