/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.unix;

import com.facebook.presto.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.shaded.org.apache.commons.lang.SystemUtils;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.NativeCodeLoader;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public class DomainSocket
implements Closeable {
    static Log LOG;
    private static boolean validateBindPaths;
    private static final String loadingFailureReason;
    private final AtomicInteger status;
    private static final int STATUS_CLOSED_MASK = 0x40000000;
    private final int fd;
    private final String path;
    private final DomainInputStream inputStream = new DomainInputStream();
    private final DomainOutputStream outputStream = new DomainOutputStream();
    private final DomainChannel channel = new DomainChannel();
    public static final int SND_BUF_SIZE = 1;
    public static final int RCV_BUF_SIZE = 2;
    public static final int SND_TIMEO = 3;
    public static final int RCV_TIMEO = 4;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static native void anchorNative();

    @VisibleForTesting
    static native void validateSocketPathSecurity0(String var0, int var1) throws IOException;

    public static String getLoadingFailureReason() {
        return loadingFailureReason;
    }

    @VisibleForTesting
    public static void disableBindPathValidation() {
        validateBindPaths = false;
    }

    public static String getEffectivePath(String path, int port) {
        return path.replace("_PORT", String.valueOf(port));
    }

    private DomainSocket(String path, int fd) {
        this.status = new AtomicInteger(0);
        this.fd = fd;
        this.path = path;
    }

    private static native int bind0(String var0) throws IOException;

    public static DomainSocket bindAndListen(String path) throws IOException {
        if (loadingFailureReason != null) {
            throw new UnsupportedOperationException(loadingFailureReason);
        }
        if (validateBindPaths) {
            DomainSocket.validateSocketPathSecurity0(path, 0);
        }
        int fd = DomainSocket.bind0(path);
        return new DomainSocket(path, fd);
    }

    private static native int accept0(int var0) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainSocket accept() throws IOException {
        this.fdRef();
        boolean exc = true;
        try {
            DomainSocket ret = new DomainSocket(this.path, DomainSocket.accept0(this.fd));
            exc = false;
            DomainSocket domainSocket = ret;
            return domainSocket;
        }
        finally {
            this.fdUnref(exc);
        }
    }

    private static native int connect0(String var0);

    public static DomainSocket connect(String path) throws IOException {
        if (loadingFailureReason != null) {
            throw new UnsupportedOperationException(loadingFailureReason);
        }
        int fd = DomainSocket.connect0(path);
        return new DomainSocket(path, fd);
    }

    private void fdRef() throws ClosedChannelException {
        int bits = this.status.incrementAndGet();
        if ((bits & 0x40000000) != 0) {
            this.status.decrementAndGet();
            throw new ClosedChannelException();
        }
    }

    private void fdUnref(boolean checkClosed) throws AsynchronousCloseException {
        int newCount = this.status.decrementAndGet();
        if (!$assertionsDisabled && (newCount & 0xBFFFFFFF) < 0) {
            throw new AssertionError();
        }
        if (checkClosed && (newCount & 0x40000000) != 0) {
            throw new AsynchronousCloseException();
        }
    }

    public boolean isOpen() {
        return (this.status.get() & 0x40000000) == 0;
    }

    public String getPath() {
        return this.path;
    }

    public DomainInputStream getInputStream() {
        return this.inputStream;
    }

    public DomainOutputStream getOutputStream() {
        return this.outputStream;
    }

    public DomainChannel getChannel() {
        return this.channel;
    }

    private static native void setAttribute0(int var0, int var1, int var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(int type, int size) throws IOException {
        this.fdRef();
        boolean exc = true;
        try {
            DomainSocket.setAttribute0(this.fd, type, size);
            exc = false;
        }
        finally {
            this.fdUnref(exc);
        }
    }

    private native int getAttribute0(int var1, int var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttribute(int type) throws IOException {
        this.fdRef();
        boolean exc = true;
        try {
            int attribute = this.getAttribute0(this.fd, type);
            exc = false;
            int n = attribute;
            return n;
        }
        finally {
            this.fdUnref(exc);
        }
    }

    private static native void close0(int var0) throws IOException;

    private static native void closeFileDescriptor0(FileDescriptor var0) throws IOException;

    private static native void shutdown0(int var0) throws IOException;

    @Override
    public void close() throws IOException {
        int bits;
        do {
            if (((bits = this.status.get()) & 0x40000000) == 0) continue;
            return;
        } while (!this.status.compareAndSet(bits, bits | 0x40000000));
        boolean didShutdown = false;
        boolean interrupted = false;
        while ((bits & 0xBFFFFFFF) > 0) {
            if (!didShutdown) {
                try {
                    DomainSocket.shutdown0(this.fd);
                }
                catch (IOException e) {
                    LOG.error("shutdown error: ", e);
                }
                didShutdown = true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            bits = this.status.get();
        }
        DomainSocket.close0(this.fd);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void sendFileDescriptors0(int var0, FileDescriptor[] var1, byte[] var2, int var3, int var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFileDescriptors(FileDescriptor[] jfds, byte[] jbuf, int offset, int length) throws IOException {
        this.fdRef();
        boolean exc = true;
        try {
            DomainSocket.sendFileDescriptors0(this.fd, jfds, jbuf, offset, length);
            exc = false;
        }
        finally {
            this.fdUnref(exc);
        }
    }

    private static native int receiveFileDescriptors0(int var0, FileDescriptor[] var1, byte[] var2, int var3, int var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveFileDescriptors(FileDescriptor[] jfds, byte[] jbuf, int offset, int length) throws IOException {
        this.fdRef();
        boolean exc = true;
        try {
            int nBytes = DomainSocket.receiveFileDescriptors0(this.fd, jfds, jbuf, offset, length);
            exc = false;
            int n = nBytes;
            return n;
        }
        finally {
            this.fdUnref(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recvFileInputStreams(FileInputStream[] fis, byte[] buf, int offset, int length) throws IOException {
        int n;
        boolean success;
        block23: {
            FileDescriptor[] fds = new FileDescriptor[fis.length];
            success = false;
            for (int i = 0; i < fis.length; ++i) {
                fis[i] = null;
            }
            this.fdRef();
            try {
                int ret = DomainSocket.receiveFileDescriptors0(this.fd, fds, buf, offset, length);
                int j = 0;
                for (int i = 0; i < fds.length; ++i) {
                    if (fds[i] == null) continue;
                    fis[j++] = new FileInputStream(fds[i]);
                    fds[i] = null;
                }
                success = true;
                n = ret;
                if (success) break block23;
            }
            catch (Throwable throwable) {
                if (!success) {
                    for (int i = 0; i < fds.length; ++i) {
                        if (fds[i] != null) {
                            try {
                                DomainSocket.closeFileDescriptor0(fds[i]);
                            }
                            catch (Throwable t) {
                                LOG.warn(t);
                            }
                            continue;
                        }
                        if (fis[i] == null) continue;
                        try {
                            fis[i].close();
                            continue;
                        }
                        catch (Throwable t) {
                            LOG.warn(t);
                            continue;
                        }
                        finally {
                            fis[i] = null;
                        }
                    }
                }
                this.fdUnref(!success);
                throw throwable;
            }
            for (int i = 0; i < fds.length; ++i) {
                if (fds[i] != null) {
                    try {
                        DomainSocket.closeFileDescriptor0(fds[i]);
                    }
                    catch (Throwable t) {
                        LOG.warn(t);
                    }
                    continue;
                }
                if (fis[i] == null) continue;
                try {
                    fis[i].close();
                    continue;
                }
                catch (Throwable t) {
                    LOG.warn(t);
                    continue;
                }
                finally {
                    fis[i] = null;
                }
            }
        }
        this.fdUnref(!success);
        return n;
    }

    private static native int readArray0(int var0, byte[] var1, int var2, int var3) throws IOException;

    private static native int available0(int var0) throws IOException;

    private static native void write0(int var0, int var1) throws IOException;

    private static native void writeArray0(int var0, byte[] var1, int var2, int var3) throws IOException;

    private static native int readByteBufferDirect0(int var0, ByteBuffer var1, int var2, int var3) throws IOException;

    public String toString() {
        return String.format("DomainSocket(fd=%d,path=%s)", this.fd, this.path);
    }

    static {
        boolean bl = $assertionsDisabled = !DomainSocket.class.desiredAssertionStatus();
        if (SystemUtils.IS_OS_WINDOWS) {
            loadingFailureReason = "UNIX Domain sockets are not available on Windows.";
        } else if (!NativeCodeLoader.isNativeCodeLoaded()) {
            loadingFailureReason = "libhadoop cannot be loaded.";
        } else {
            String problem = "DomainSocket#anchorNative got error: unknown";
            try {
                DomainSocket.anchorNative();
                problem = null;
            }
            catch (Throwable t) {
                problem = "DomainSocket#anchorNative got error: " + t.getMessage();
            }
            loadingFailureReason = problem;
        }
        LOG = LogFactory.getLog(DomainSocket.class);
        validateBindPaths = true;
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public class DomainChannel
    implements ReadableByteChannel {
        @Override
        public boolean isOpen() {
            return DomainSocket.this.isOpen();
        }

        @Override
        public void close() throws IOException {
            DomainSocket.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(ByteBuffer dst) throws IOException {
            DomainSocket.this.fdRef();
            boolean exc = true;
            try {
                int nread = 0;
                if (dst.isDirect()) {
                    nread = DomainSocket.readByteBufferDirect0(DomainSocket.this.fd, dst, dst.position(), dst.remaining());
                } else if (dst.hasArray()) {
                    nread = DomainSocket.readArray0(DomainSocket.this.fd, dst.array(), dst.position() + dst.arrayOffset(), dst.remaining());
                } else {
                    throw new AssertionError((Object)"we don't support using ByteBuffers that aren't either direct or backed by arrays");
                }
                if (nread > 0) {
                    dst.position(dst.position() + nread);
                }
                exc = false;
                int n = nread;
                return n;
            }
            finally {
                DomainSocket.this.fdUnref(exc);
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public class DomainOutputStream
    extends OutputStream {
        @Override
        public void close() throws IOException {
            DomainSocket.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int val) throws IOException {
            DomainSocket.this.fdRef();
            boolean exc = true;
            try {
                byte[] b = new byte[]{(byte)val};
                DomainSocket.writeArray0(DomainSocket.this.fd, b, 0, 1);
                exc = false;
            }
            finally {
                DomainSocket.this.fdUnref(exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            DomainSocket.this.fdRef();
            boolean exc = true;
            try {
                DomainSocket.writeArray0(DomainSocket.this.fd, b, off, len);
                exc = false;
            }
            finally {
                DomainSocket.this.fdUnref(exc);
            }
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"HDFS"})
    public class DomainInputStream
    extends InputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            DomainSocket.this.fdRef();
            boolean exc = true;
            try {
                byte[] b = new byte[1];
                int ret = DomainSocket.readArray0(DomainSocket.this.fd, b, 0, 1);
                exc = false;
                int n = ret >= 0 ? b[0] : -1;
                return n;
            }
            finally {
                DomainSocket.this.fdUnref(exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            DomainSocket.this.fdRef();
            boolean exc = true;
            try {
                int nRead = DomainSocket.readArray0(DomainSocket.this.fd, b, off, len);
                exc = false;
                int n = nRead;
                return n;
            }
            finally {
                DomainSocket.this.fdUnref(exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            DomainSocket.this.fdRef();
            boolean exc = true;
            try {
                int nAvailable = DomainSocket.available0(DomainSocket.this.fd);
                exc = false;
                int n = nAvailable;
                return n;
            }
            finally {
                DomainSocket.this.fdUnref(exc);
            }
        }

        @Override
        public void close() throws IOException {
            DomainSocket.this.close();
        }
    }
}

