/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.hive.CacheQuota;
import java.util.Objects;
import java.util.Optional;

public class HiveFileContext {
    public static final HiveFileContext DEFAULT_HIVE_FILE_CONTEXT = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), Optional.empty(), 0L, false);
    private final boolean cacheable;
    private final CacheQuota cacheQuota;
    private final Optional<ExtraHiveFileInfo<?>> extraFileInfo;
    private final Optional<Long> fileSize;
    private final long modificationTime;
    private final boolean verboseRuntimeStatsEnabled;
    private final RuntimeStats stats = new RuntimeStats();

    public HiveFileContext(boolean cacheable, CacheQuota cacheQuota, Optional<ExtraHiveFileInfo<?>> extraFileInfo, Optional<Long> fileSize, long modificationTime, boolean verboseRuntimeStatsEnabled) {
        this.cacheable = cacheable;
        this.cacheQuota = Objects.requireNonNull(cacheQuota, "cacheQuota is null");
        this.extraFileInfo = Objects.requireNonNull(extraFileInfo, "extraFileInfo is null");
        this.fileSize = Objects.requireNonNull(fileSize, "fileSize is null");
        this.modificationTime = modificationTime;
        this.verboseRuntimeStatsEnabled = verboseRuntimeStatsEnabled;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public CacheQuota getCacheQuota() {
        return this.cacheQuota;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public Optional<ExtraHiveFileInfo<?>> getExtraFileInfo() {
        return this.extraFileInfo;
    }

    public Optional<Long> getFileSize() {
        return this.fileSize;
    }

    public void incrementCounter(String name, long value) {
        if (this.verboseRuntimeStatsEnabled) {
            this.stats.addMetricValue(name, value);
        }
    }

    public RuntimeStats getStats() {
        return this.stats;
    }

    public static interface ExtraHiveFileInfo<T> {
        public T getExtraFileInfo();
    }
}

