/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.hive.CacheQuota;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class HiveFileContext {
    public static final HiveFileContext DEFAULT_HIVE_FILE_CONTEXT = new HiveFileContext(true, CacheQuota.NO_CACHE_CONSTRAINTS, Optional.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), 0L, false);
    private final boolean cacheable;
    private final CacheQuota cacheQuota;
    private final Optional<ExtraHiveFileInfo<?>> extraFileInfo;
    private final OptionalLong fileSize;
    private final OptionalLong startOffset;
    private final OptionalLong length;
    private final long modificationTime;
    private final boolean verboseRuntimeStatsEnabled;
    private final RuntimeStats stats = new RuntimeStats();

    public HiveFileContext(boolean cacheable, CacheQuota cacheQuota, Optional<ExtraHiveFileInfo<?>> extraFileInfo, OptionalLong fileSize, OptionalLong startOffset, OptionalLong length, long modificationTime, boolean verboseRuntimeStatsEnabled) {
        this.cacheable = cacheable;
        this.cacheQuota = Objects.requireNonNull(cacheQuota, "cacheQuota is null");
        this.extraFileInfo = Objects.requireNonNull(extraFileInfo, "extraFileInfo is null");
        this.fileSize = Objects.requireNonNull(fileSize, "fileSize is null");
        this.startOffset = Objects.requireNonNull(startOffset, "startOffset is null");
        this.length = Objects.requireNonNull(length, "length is null");
        this.modificationTime = modificationTime;
        this.verboseRuntimeStatsEnabled = verboseRuntimeStatsEnabled;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public CacheQuota getCacheQuota() {
        return this.cacheQuota;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public Optional<ExtraHiveFileInfo<?>> getExtraFileInfo() {
        return this.extraFileInfo;
    }

    public OptionalLong getFileSize() {
        return this.fileSize;
    }

    public OptionalLong getStartOffset() {
        return this.startOffset;
    }

    public OptionalLong getLength() {
        return this.length;
    }

    public void incrementCounter(String name, RuntimeUnit unit, long value) {
        if (this.verboseRuntimeStatsEnabled) {
            this.stats.addMetricValue(name, unit, value);
        }
    }

    public RuntimeStats getStats() {
        return this.stats;
    }

    public static interface ExtraHiveFileInfo<T> {
        public T getExtraFileInfo();
    }
}

