/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;

public class HiveFileInfo
implements Comparable {
    private final Path path;
    private final boolean isDirectory;
    private final BlockLocation[] blockLocations;
    private final long length;
    private final long fileModifiedTime;
    private final Optional<byte[]> extraFileInfo;
    private final Map<String, String> customSplitInfo;

    public static HiveFileInfo createHiveFileInfo(LocatedFileStatus locatedFileStatus, Optional<byte[]> extraFileContext) {
        return HiveFileInfo.createHiveFileInfo(locatedFileStatus, extraFileContext, (Map<String, String>)ImmutableMap.of());
    }

    public static HiveFileInfo createHiveFileInfo(LocatedFileStatus locatedFileStatus, Optional<byte[]> extraFileContext, Map<String, String> customSplitInfo) {
        return new HiveFileInfo(locatedFileStatus.getPath(), locatedFileStatus.isDirectory(), locatedFileStatus.getBlockLocations(), locatedFileStatus.getLen(), locatedFileStatus.getModificationTime(), extraFileContext, customSplitInfo);
    }

    private HiveFileInfo(Path path, boolean isDirectory, BlockLocation[] blockLocations, long length, long fileModifiedTime, Optional<byte[]> extraFileInfo, Map<String, String> customSplitInfo) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.isDirectory = isDirectory;
        this.blockLocations = blockLocations;
        this.length = length;
        this.fileModifiedTime = fileModifiedTime;
        this.extraFileInfo = Objects.requireNonNull(extraFileInfo, "extraFileInfo is null");
        this.customSplitInfo = Objects.requireNonNull(customSplitInfo, "customSplitInfo is null");
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public BlockLocation[] getBlockLocations() {
        return this.blockLocations;
    }

    public long getLength() {
        return this.length;
    }

    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    public Optional<byte[]> getExtraFileInfo() {
        return this.extraFileInfo;
    }

    public Map<String, String> getCustomSplitInfo() {
        return this.customSplitInfo;
    }

    public int compareTo(Object o) {
        HiveFileInfo other = (HiveFileInfo)o;
        return this.getPath().compareTo((Object)other.getPath());
    }
}

