/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HdfsContext {
    private final ConnectorIdentity identity;
    private final Optional<String> source;
    private final Optional<String> queryId;
    private final Optional<String> schemaName;
    private final Optional<String> tableName;
    private final Optional<String> tablePath;
    private final Optional<Boolean> isNewTable;
    private final Optional<String> clientInfo;
    private final Optional<Set<String>> clientTags;
    private final Optional<ConnectorSession> session;

    @Deprecated
    public HdfsContext(ConnectorIdentity identity) {
        this.identity = Objects.requireNonNull(identity, "identity is null");
        this.source = Optional.empty();
        this.queryId = Optional.empty();
        this.schemaName = Optional.empty();
        this.tableName = Optional.empty();
        this.clientInfo = Optional.empty();
        this.clientTags = Optional.empty();
        this.tablePath = Optional.empty();
        this.isNewTable = Optional.empty();
        this.session = Optional.empty();
    }

    @Deprecated
    public HdfsContext(ConnectorSession session) {
        this(session, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HdfsContext(ConnectorSession session, String schemaName) {
        this(session, Optional.of(Objects.requireNonNull(schemaName, "schemaName is null")), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Deprecated
    public HdfsContext(ConnectorSession session, String schemaName, String tableName) {
        this(session, Optional.of(Objects.requireNonNull(schemaName, "schemaName is null")), Optional.of(Objects.requireNonNull(tableName, "tableName is null")), Optional.empty(), Optional.empty());
    }

    public HdfsContext(ConnectorSession session, String schemaName, String tableName, String tablePath, boolean isNewTable) {
        this(session, Optional.of(Objects.requireNonNull(schemaName, "schemaName is null")), Optional.of(Objects.requireNonNull(tableName, "tableName is null")), Optional.of(Objects.requireNonNull(tablePath, "tablePath is null")), Optional.of(isNewTable));
    }

    private HdfsContext(ConnectorSession session, Optional<String> schemaName, Optional<String> tableName, Optional<String> tablePath, Optional<Boolean> isNewTable) {
        this.session = Optional.of(Objects.requireNonNull(session, "session is null"));
        this.identity = Objects.requireNonNull(session.getIdentity(), "session.getIdentity() is null");
        this.source = Objects.requireNonNull(session.getSource(), "session.getSource() is null");
        this.queryId = Optional.of(session.getQueryId());
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.clientInfo = session.getClientInfo();
        this.clientTags = Optional.of(session.getClientTags());
        this.tablePath = Objects.requireNonNull(tablePath, "tablePath is null");
        this.isNewTable = Objects.requireNonNull(isNewTable, "isNewTable is null");
    }

    public ConnectorIdentity getIdentity() {
        return this.identity;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getQueryId() {
        return this.queryId;
    }

    public Optional<String> getSchemaName() {
        return this.schemaName;
    }

    public Optional<String> getTableName() {
        return this.tableName;
    }

    public Optional<String> getTablePath() {
        return this.tablePath;
    }

    public Optional<Boolean> isNewTable() {
        return this.isNewTable;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Optional<Set<String>> getClientTags() {
        return this.clientTags;
    }

    public Optional<ConnectorSession> getSession() {
        return this.session;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("user", (Object)this.identity).add("source", this.source.orElse(null)).add("queryId", this.queryId.orElse(null)).add("schemaName", this.schemaName.orElse(null)).add("tableName", this.tableName.orElse(null)).add("tablePath", this.tablePath.orElse(null)).add("isNewTable", this.isNewTable.orElse(null)).add("clientInfo", this.clientInfo.orElse(null)).add("clientTags", this.clientTags.orElse(null)).add("session", this.session.orElse(null)).toString();
    }
}

