/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.zorder;

import com.facebook.presto.hive.zorder.ZAddressRange;
import com.facebook.presto.hive.zorder.ZOrder;
import com.facebook.presto.hive.zorder.ZValueRange;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestZOrder {
    private static final long[][] EXPECTED_Z_ADDRESSES = new long[][]{{0L, 1L, 4L, 5L, 16L, 17L, 20L, 21L}, {2L, 3L, 6L, 7L, 18L, 19L, 22L, 23L}, {8L, 9L, 12L, 13L, 24L, 25L, 28L, 29L}, {10L, 11L, 14L, 15L, 26L, 27L, 30L, 31L}, {32L, 33L, 36L, 37L, 48L, 49L, 52L, 53L}, {34L, 35L, 38L, 39L, 50L, 51L, 54L, 55L}, {40L, 41L, 44L, 45L, 56L, 57L, 60L, 61L}, {42L, 43L, 46L, 47L, 58L, 59L, 62L, 63L}};
    private static final ZValueRange[][] SEARCH_CURVE_RANGES = new ZValueRange[][]{{new ZValueRange((List)ImmutableList.of(Optional.of(0)), (List)ImmutableList.of(Optional.of(1))), new ZValueRange((List)ImmutableList.of(Optional.of(-2)), (List)ImmutableList.of(Optional.of(-1)))}, {new ZValueRange((List)ImmutableList.of(Optional.of(-1)), (List)ImmutableList.of(Optional.of(0))), new ZValueRange((List)ImmutableList.of(Optional.of(-1)), (List)ImmutableList.of(Optional.of(0)))}, {new ZValueRange((List)ImmutableList.of(Optional.of(0)), (List)ImmutableList.of(Optional.of(1))), new ZValueRange((List)ImmutableList.of(Optional.of(-4)), (List)ImmutableList.of(Optional.of(-1)))}};
    private static final ZAddressRange<Long>[][] EXPECTED_Z_ADDRESS_RANGES = new ZAddressRange[][]{{new ZAddressRange((Object)36L, (Object)39L)}, {new ZAddressRange((Object)15L, (Object)15L), new ZAddressRange((Object)26L, (Object)26L), new ZAddressRange((Object)37L, (Object)37L), new ZAddressRange((Object)48L, (Object)48L)}, {new ZAddressRange((Object)32L, (Object)39L)}};

    @Test
    public void testZOrderDifferentListSizes() {
        ImmutableList bitPositions = ImmutableList.of((Object)8, (Object)8, (Object)8, (Object)8, (Object)8, (Object)8, (Object)8, (Object)8);
        ZOrder zOrder = new ZOrder((List)bitPositions, true);
        ImmutableList intColumns = ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)9, (Object)10);
        try {
            zOrder.encodeToByteArray((List)intColumns);
            Assert.fail((String)"Expected test to fail: input list size is greater than bit position list size.");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = String.format("Input list size (%d) does not match encoding bits list size (%d).", intColumns.size(), bitPositions.size());
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testZOrderTooManyIntegers() {
        Random rand = new Random();
        int listLength = 11;
        ArrayList<Integer> intColumns = new ArrayList<Integer>(listLength);
        ArrayList<Integer> bitPositions = new ArrayList<Integer>(listLength);
        for (int i = 0; i < listLength; ++i) {
            int value = rand.nextInt(Integer.MAX_VALUE);
            intColumns.add(value);
            bitPositions.add(TestZOrder.getHighestSetBitPosition(value) + 1);
        }
        ZOrder zOrder = new ZOrder(bitPositions, true);
        try {
            zOrder.encodeToByteArray(intColumns);
            Assert.fail((String)String.format("Expected test to fail: z-ordering does not support more than %d integers.", 10));
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = String.format("Current Z-Ordering implementation does not support more than %d input numbers.", 10);
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testZOrderNullInput() {
        ZOrder zOrder = new ZOrder((List)ImmutableList.of((Object)8, (Object)8), true);
        try {
            zOrder.encodeToByteArray(null);
            Assert.fail((String)"Expected test to fail: input list should not be null.");
        }
        catch (NullPointerException e) {
            String expectedMessage = "Input list should not be null.";
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testZOrderEmptyInput() {
        ZOrder zOrder = new ZOrder((List)ImmutableList.of((Object)8, (Object)8), true);
        ImmutableList intColumns = ImmutableList.of();
        try {
            zOrder.encodeToByteArray((List)intColumns);
            Assert.fail((String)"Expected test to fail: input size should be greater than zero.");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "Input list size should be greater than zero.";
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testZOrderNullEncodingBits() {
        try {
            new ZOrder(null, true);
            Assert.fail((String)"Expected test to fail: encoding bits list should not be null.");
        }
        catch (NullPointerException e) {
            String expectedMessage = "Encoding bits list should not be null.";
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testZOrderEmptyEncodingBits() {
        try {
            new ZOrder((List)ImmutableList.of(), true);
            Assert.fail((String)"Expected test to fail: encoding bits list should not be empty.");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "Encoding bits list should not be empty.";
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testNonMatchingEncodeBits() {
        ImmutableList bitPositions = ImmutableList.of((Object)8, (Object)2, (Object)8, (Object)4, (Object)4, (Object)2, (Object)6, (Object)4, (Object)8, (Object)2);
        ZOrder zOrder = new ZOrder((List)bitPositions);
        ImmutableList intColumns = ImmutableList.of((Object)1, (Object)6, (Object)32, (Object)3, (Object)7, (Object)0, (Object)17, (Object)5, (Object)125, (Object)1);
        try {
            zOrder.encodeToInteger((List)intColumns);
            Assert.fail((String)"Expected test to fail: encoding bits list should not be empty.");
        }
        catch (IllegalArgumentException e) {
            int expectedErrorIndex = 1;
            String expectedMessage = String.format("Input value %d at index %d should not have more than %d bits.", intColumns.get(expectedErrorIndex), expectedErrorIndex, bitPositions.get(expectedErrorIndex));
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testZOrderToByteArrayWithoutNegatives() {
        ZOrder zOrder = new ZOrder((List)ImmutableList.of((Object)3, (Object)3), true);
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                ImmutableList intColumns = ImmutableList.of((Object)x, (Object)y);
                byte[] byteAddress = zOrder.encodeToByteArray((List)intColumns);
                long address = zOrder.zOrderByteAddressToLong(byteAddress);
                Assert.assertEquals((long)address, (long)EXPECTED_Z_ADDRESSES[x][y]);
                List decodedIntCols = zOrder.decode(byteAddress);
                Assert.assertEquals((Collection)intColumns, (Collection)decodedIntCols, (String)"Integers decoded improperly");
            }
        }
    }

    @Test
    public void testZOrderToByteArrayWithNegatives() {
        ZOrder zOrder = new ZOrder((List)ImmutableList.of((Object)2, (Object)2));
        for (int x = -4; x < 4; ++x) {
            for (int y = -4; y < 4; ++y) {
                ImmutableList intColumns = ImmutableList.of((Object)x, (Object)y);
                byte[] byteAddress = zOrder.encodeToByteArray((List)intColumns);
                long address = zOrder.zOrderByteAddressToLong(byteAddress);
                Assert.assertEquals((long)address, (long)EXPECTED_Z_ADDRESSES[x + 4][y + 4]);
                List decodedIntCols = zOrder.decode(byteAddress);
                Assert.assertEquals((Collection)intColumns, (Collection)decodedIntCols, (String)"Integers decoded improperly");
            }
        }
    }

    @Test
    public void testZOrderToLong() {
        ZOrder zOrder = new ZOrder((List)ImmutableList.of((Object)2, (Object)2));
        for (int x = -4; x < 4; ++x) {
            for (int y = -4; y < 4; ++y) {
                ImmutableList intColumns = ImmutableList.of((Object)x, (Object)y);
                long address = zOrder.encodeToLong((List)intColumns);
                Assert.assertEquals((long)address, (long)EXPECTED_Z_ADDRESSES[x + 4][y + 4]);
                List decodedIntCols = zOrder.decode(address);
                Assert.assertEquals((Collection)intColumns, (Collection)decodedIntCols, (String)"Integers decoded improperly");
            }
        }
    }

    @Test
    public void testZOrderToInt() {
        ZOrder zOrder = new ZOrder((List)ImmutableList.of((Object)2, (Object)2));
        for (int x = -4; x < 4; ++x) {
            for (int y = -4; y < 4; ++y) {
                ImmutableList intColumns = ImmutableList.of((Object)x, (Object)y);
                int address = zOrder.encodeToInteger((List)intColumns);
                Assert.assertEquals((long)address, (long)EXPECTED_Z_ADDRESSES[x + 4][y + 4]);
                List decodedIntCols = zOrder.decode(address);
                Assert.assertEquals((Collection)intColumns, (Collection)decodedIntCols, (String)"Integers decoded improperly");
            }
        }
    }

    @Test
    public void testZOrderOverLong() {
        ImmutableList bitPositions = ImmutableList.of((Object)16, (Object)16, (Object)16, (Object)16, (Object)16);
        int totalBitLength = bitPositions.stream().mapToInt(Integer::intValue).sum();
        ZOrder zOrder = new ZOrder((List)bitPositions);
        ImmutableList intColumns = ImmutableList.of((Object)20456, (Object)20456, (Object)20456, (Object)20456, (Object)20456);
        try {
            zOrder.encodeToLong((List)intColumns);
            Assert.fail((String)"Expected test to fail: total bits to encode is larger than the size of a long.");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = String.format("The z-address type specified is not large enough to hold %d values with a total of %d bits.", bitPositions.size(), totalBitLength);
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testZOrderOverInt() {
        ImmutableList bitPositions = ImmutableList.of((Object)16, (Object)16, (Object)16);
        int totalBitLength = bitPositions.stream().mapToInt(Integer::intValue).sum();
        ZOrder zOrder = new ZOrder((List)bitPositions);
        ImmutableList intColumns = ImmutableList.of((Object)20456, (Object)20456, (Object)20456);
        try {
            zOrder.encodeToInteger((List)intColumns);
            Assert.fail((String)"Expected test to fail: total bits to encode is larger than the size of a integer.");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = String.format("The z-address type specified is not large enough to hold %d values with a total of %d bits.", bitPositions.size(), totalBitLength);
            Assert.assertEquals((String)e.getMessage(), (String)expectedMessage, (String)String.format("Expected exception message '%s' to match '%s'", e.getMessage(), expectedMessage));
        }
    }

    @Test
    public void testZOrderSearchEvenCurves() {
        ImmutableList bitPositions = ImmutableList.of((Object)2, (Object)2);
        ZOrder zOrder = new ZOrder((List)bitPositions);
        for (int i = 0; i < SEARCH_CURVE_RANGES.length; ++i) {
            List ranges = Arrays.stream(SEARCH_CURVE_RANGES[i]).collect(Collectors.toList());
            List addresses = zOrder.zOrderSearchCurveLongs(ranges);
            Assert.assertEquals((Collection)addresses, (Collection)Arrays.stream(EXPECTED_Z_ADDRESS_RANGES[i]).collect(Collectors.toList()));
        }
    }

    @Test
    public void testZOrderSearchUnevenCurves() {
        ImmutableList bitPositions = ImmutableList.of((Object)1, (Object)2);
        ZOrder zOrder = new ZOrder((List)bitPositions);
        ImmutableList ranges = ImmutableList.of((Object)new ZValueRange((List)ImmutableList.of(Optional.of(-2)), (List)ImmutableList.of(Optional.of(0))), (Object)new ZValueRange((List)ImmutableList.of(Optional.of(-1)), (List)ImmutableList.of(Optional.of(2))));
        List addresses = zOrder.zOrderSearchCurveIntegers((List)ranges);
        Assert.assertEquals((Collection)addresses, (Collection)ImmutableList.of((Object)new ZAddressRange((Object)3L, (Object)3L), (Object)new ZAddressRange((Object)7L, (Object)10L), (Object)new ZAddressRange((Object)12L, (Object)14L), (Object)new ZAddressRange((Object)19L, (Object)19L), (Object)new ZAddressRange((Object)24L, (Object)26L)));
    }

    @Test
    public void testZOrderSearchCurveIntegers() {
        ImmutableList bitPositions = ImmutableList.of((Object)0, (Object)1, (Object)3);
        ZOrder zOrder = new ZOrder((List)bitPositions);
        ImmutableList ranges = ImmutableList.of((Object)new ZValueRange((List)ImmutableList.of(Optional.empty()), (List)ImmutableList.of(Optional.of(-1))), (Object)new ZValueRange((List)ImmutableList.of(Optional.of(-1)), (List)ImmutableList.of(Optional.empty())), (Object)new ZValueRange((List)ImmutableList.of(Optional.of(-1)), (List)ImmutableList.of(Optional.of(1))));
        List addresses = zOrder.zOrderSearchCurveIntegers((List)ranges);
        Assert.assertEquals((Collection)addresses, (Collection)ImmutableList.of((Object)new ZAddressRange((Object)15L, (Object)15L), (Object)new ZAddressRange((Object)24L, (Object)25L), (Object)new ZAddressRange((Object)39L, (Object)39L), (Object)new ZAddressRange((Object)47L, (Object)49L), (Object)new ZAddressRange((Object)56L, (Object)57L)));
    }

    @Test
    public void testZOrderSearchCurveMultipleRanges() {
        ImmutableList bitPositions = ImmutableList.of((Object)3);
        ZOrder zOrder = new ZOrder((List)bitPositions);
        ImmutableList ranges = ImmutableList.of((Object)new ZValueRange((List)ImmutableList.of(Optional.empty(), Optional.of(6)), (List)ImmutableList.of(Optional.of(-7), Optional.empty())));
        List addresses = zOrder.zOrderSearchCurveIntegers((List)ranges);
        Assert.assertEquals((Collection)addresses, (Collection)ImmutableList.of((Object)new ZAddressRange((Object)0L, (Object)1L), (Object)new ZAddressRange((Object)14L, (Object)15L)));
        bitPositions = ImmutableList.of((Object)3, (Object)1, (Object)2);
        zOrder = new ZOrder((List)bitPositions);
        ranges = ImmutableList.of((Object)new ZValueRange((List)ImmutableList.of(Optional.empty(), Optional.of(6)), (List)ImmutableList.of(Optional.of(-7), Optional.empty())), (Object)new ZValueRange((List)ImmutableList.of(Optional.of(0)), (List)ImmutableList.of(Optional.empty())), (Object)new ZValueRange((List)ImmutableList.of(Optional.of(1)), (List)ImmutableList.of(Optional.of(1))));
        addresses = zOrder.zOrderSearchCurveIntegers((List)ranges);
        Assert.assertEquals((Collection)addresses, (Collection)ImmutableList.of((Object)new ZAddressRange((Object)194L, (Object)195L), (Object)new ZAddressRange((Object)210L, (Object)211L), (Object)new ZAddressRange((Object)486L, (Object)487L), (Object)new ZAddressRange((Object)502L, (Object)503L)));
    }

    @Test
    public void testZOrderSearchCurveOutOfBounds() {
        ImmutableList bitPositions = ImmutableList.of((Object)1);
        ZOrder zOrder = new ZOrder((List)bitPositions);
        ImmutableList ranges = ImmutableList.of((Object)new ZValueRange((List)ImmutableList.of(Optional.of(-3)), (List)ImmutableList.of(Optional.of(-3))));
        List addresses = zOrder.zOrderSearchCurveIntegers((List)ranges);
        Assert.assertEquals((Collection)addresses, (Collection)ImmutableList.of());
        ranges = ImmutableList.of((Object)new ZValueRange((List)ImmutableList.of(Optional.of(3)), (List)ImmutableList.of(Optional.of(3))));
        addresses = zOrder.zOrderSearchCurveIntegers((List)ranges);
        Assert.assertEquals((Collection)addresses, (Collection)ImmutableList.of());
    }

    private static int getHighestSetBitPosition(int value) {
        int position = 0;
        while (value != 0) {
            value >>= 1;
            ++position;
        }
        return position;
    }
}

