/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import io.airlift.units.DataSize;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;

public class HiveCommonClientConfig {
    private NodeSelectionStrategy nodeSelectionStrategy = NodeSelectionStrategy.NO_PREFERENCE;
    private boolean orcBloomFiltersEnabled;
    private boolean orcLazyReadSmallRanges = true;
    private DataSize orcMaxBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxMergeDistance = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxReadBlockSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean orcOptimizedWriterEnabled = true;
    private DataSize orcStreamBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private OrcWriteValidation.OrcWriteValidationMode orcWriterValidationMode = OrcWriteValidation.OrcWriteValidationMode.BOTH;
    private double orcWriterValidationPercentage;
    private DataSize orcTinyStripeThreshold = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private boolean parquetBatchReadOptimizationEnabled;
    private boolean parquetEnableBatchReaderVerification;
    private DataSize parquetMaxReadBlockSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean rangeFiltersOnSubscriptsEnabled;
    private boolean readNullMaskedParquetEncryptedValueEnabled;
    private boolean useParquetColumnNames;
    private boolean zstdJniDecompressionEnabled;

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    @Config(value="hive.node-selection-strategy")
    public HiveCommonClientConfig setNodeSelectionStrategy(NodeSelectionStrategy nodeSelectionStrategy) {
        this.nodeSelectionStrategy = nodeSelectionStrategy;
        return this;
    }

    public boolean isOrcBloomFiltersEnabled() {
        return this.orcBloomFiltersEnabled;
    }

    @Config(value="hive.orc.bloom-filters.enabled")
    public HiveCommonClientConfig setOrcBloomFiltersEnabled(boolean orcBloomFiltersEnabled) {
        this.orcBloomFiltersEnabled = orcBloomFiltersEnabled;
        return this;
    }

    @Deprecated
    public boolean isOrcLazyReadSmallRanges() {
        return this.orcLazyReadSmallRanges;
    }

    @Deprecated
    @Config(value="hive.orc.lazy-read-small-ranges")
    @ConfigDescription(value="ORC read small disk ranges lazily")
    public HiveCommonClientConfig setOrcLazyReadSmallRanges(boolean orcLazyReadSmallRanges) {
        this.orcLazyReadSmallRanges = orcLazyReadSmallRanges;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxBufferSize() {
        return this.orcMaxBufferSize;
    }

    @Config(value="hive.orc.max-buffer-size")
    public HiveCommonClientConfig setOrcMaxBufferSize(DataSize orcMaxBufferSize) {
        this.orcMaxBufferSize = orcMaxBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxMergeDistance() {
        return this.orcMaxMergeDistance;
    }

    @Config(value="hive.orc.max-merge-distance")
    public HiveCommonClientConfig setOrcMaxMergeDistance(DataSize orcMaxMergeDistance) {
        this.orcMaxMergeDistance = orcMaxMergeDistance;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxReadBlockSize() {
        return this.orcMaxReadBlockSize;
    }

    @Config(value="hive.orc.max-read-block-size")
    public HiveCommonClientConfig setOrcMaxReadBlockSize(DataSize orcMaxReadBlockSize) {
        this.orcMaxReadBlockSize = orcMaxReadBlockSize;
        return this;
    }

    @Deprecated
    public boolean isOrcOptimizedWriterEnabled() {
        return this.orcOptimizedWriterEnabled;
    }

    @Deprecated
    @Config(value="hive.orc.optimized-writer.enabled")
    public HiveCommonClientConfig setOrcOptimizedWriterEnabled(boolean orcOptimizedWriterEnabled) {
        this.orcOptimizedWriterEnabled = orcOptimizedWriterEnabled;
        return this;
    }

    @NotNull
    public DataSize getOrcStreamBufferSize() {
        return this.orcStreamBufferSize;
    }

    @Config(value="hive.orc.stream-buffer-size")
    public HiveCommonClientConfig setOrcStreamBufferSize(DataSize orcStreamBufferSize) {
        this.orcStreamBufferSize = orcStreamBufferSize;
        return this;
    }

    @NotNull
    public OrcWriteValidation.OrcWriteValidationMode getOrcWriterValidationMode() {
        return this.orcWriterValidationMode;
    }

    @Config(value="hive.orc.writer.validation-mode")
    @ConfigDescription(value="Level of detail in ORC validation. Lower levels require more memory.")
    public HiveCommonClientConfig setOrcWriterValidationMode(OrcWriteValidation.OrcWriteValidationMode orcWriterValidationMode) {
        this.orcWriterValidationMode = orcWriterValidationMode;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="100.0") double getOrcWriterValidationPercentage() {
        return this.orcWriterValidationPercentage;
    }

    @Config(value="hive.orc.writer.validation-percentage")
    @ConfigDescription(value="Percentage of ORC files to validate after write by re-reading the whole file")
    public HiveCommonClientConfig setOrcWriterValidationPercentage(double orcWriterValidationPercentage) {
        this.orcWriterValidationPercentage = orcWriterValidationPercentage;
        return this;
    }

    @NotNull
    public DataSize getOrcTinyStripeThreshold() {
        return this.orcTinyStripeThreshold;
    }

    @Config(value="hive.orc.tiny-stripe-threshold")
    public HiveCommonClientConfig setOrcTinyStripeThreshold(DataSize orcTinyStripeThreshold) {
        this.orcTinyStripeThreshold = orcTinyStripeThreshold;
        return this;
    }

    @Config(value="hive.parquet-batch-read-optimization-enabled")
    @ConfigDescription(value="enable parquet batch reads optimization")
    public HiveCommonClientConfig setParquetBatchReadOptimizationEnabled(boolean parquetBatchReadOptimizationEnabled) {
        this.parquetBatchReadOptimizationEnabled = parquetBatchReadOptimizationEnabled;
        return this;
    }

    public boolean isParquetBatchReadOptimizationEnabled() {
        return this.parquetBatchReadOptimizationEnabled;
    }

    @Config(value="hive.enable-parquet-batch-reader-verification")
    @ConfigDescription(value="enable optimized parquet reader")
    public HiveCommonClientConfig setParquetBatchReaderVerificationEnabled(boolean parquetEnableBatchReaderVerification) {
        this.parquetEnableBatchReaderVerification = parquetEnableBatchReaderVerification;
        return this;
    }

    public boolean isParquetBatchReaderVerificationEnabled() {
        return this.parquetEnableBatchReaderVerification;
    }

    @NotNull
    public DataSize getParquetMaxReadBlockSize() {
        return this.parquetMaxReadBlockSize;
    }

    @Config(value="hive.parquet.max-read-block-size")
    public HiveCommonClientConfig setParquetMaxReadBlockSize(DataSize parquetMaxReadBlockSize) {
        this.parquetMaxReadBlockSize = parquetMaxReadBlockSize;
        return this;
    }

    public boolean isRangeFiltersOnSubscriptsEnabled() {
        return this.rangeFiltersOnSubscriptsEnabled;
    }

    @Config(value="hive.range-filters-on-subscripts-enabled")
    @ConfigDescription(value="Experimental: enable pushdown of range filters on subscripts (a[2] = 5) into ORC column readers")
    public HiveCommonClientConfig setRangeFiltersOnSubscriptsEnabled(boolean rangeFiltersOnSubscriptsEnabled) {
        this.rangeFiltersOnSubscriptsEnabled = rangeFiltersOnSubscriptsEnabled;
        return this;
    }

    @Config(value="hive.read-null-masked-parquet-encrypted-value-enabled")
    @ConfigDescription(value="Read null masked value when access is denied for an encrypted parquet column")
    public HiveCommonClientConfig setReadNullMaskedParquetEncryptedValue(boolean readNullMaskedParquetEncryptedValueEnabled) {
        this.readNullMaskedParquetEncryptedValueEnabled = readNullMaskedParquetEncryptedValueEnabled;
        return this;
    }

    public boolean getReadNullMaskedParquetEncryptedValue() {
        return this.readNullMaskedParquetEncryptedValueEnabled;
    }

    public boolean isUseParquetColumnNames() {
        return this.useParquetColumnNames;
    }

    @Config(value="hive.parquet.use-column-names")
    @ConfigDescription(value="Access Parquet columns using names from the file")
    public HiveCommonClientConfig setUseParquetColumnNames(boolean useParquetColumnNames) {
        this.useParquetColumnNames = useParquetColumnNames;
        return this;
    }

    public boolean isZstdJniDecompressionEnabled() {
        return this.zstdJniDecompressionEnabled;
    }

    @Config(value="hive.zstd-jni-decompression-enabled")
    public HiveCommonClientConfig setZstdJniDecompressionEnabled(boolean zstdJniDecompressionEnabled) {
        this.zstdJniDecompressionEnabled = zstdJniDecompressionEnabled;
        return this;
    }
}

