/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public class BlockLocation {
    private final List<String> hosts;
    private final long offset;
    private final long length;

    @ThriftConstructor
    public BlockLocation(List<String> hosts, long offset, long length) {
        this.hosts = Objects.requireNonNull(hosts, "hosts is null");
        this.offset = offset;
        this.length = length;
    }

    public BlockLocation(org.apache.hadoop.fs.BlockLocation blockLocation) throws IOException {
        this.hosts = ImmutableList.copyOf((Object[])Objects.requireNonNull(blockLocation, "blockLocation is null").getHosts());
        this.offset = blockLocation.getOffset();
        this.length = blockLocation.getLength();
    }

    public static List<BlockLocation> fromHiveBlockLocations(@Nullable org.apache.hadoop.fs.BlockLocation[] blockLocations) throws IOException {
        if (blockLocations == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (org.apache.hadoop.fs.BlockLocation blockLocation : blockLocations) {
            result.add((Object)new BlockLocation(blockLocation));
        }
        return result.build();
    }

    @ThriftField(value=1)
    public List<String> getHosts() {
        return this.hosts;
    }

    @ThriftField(value=2)
    public long getOffset() {
        return this.offset;
    }

    @ThriftField(value=3)
    public long getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockLocation that = (BlockLocation)o;
        return this.offset == that.offset && this.length == that.length && this.hosts.equals(that.hosts);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.offset, this.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hosts", this.hosts).add("offset", this.offset).add("length", this.length).toString();
    }
}

