/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.hive.BlockLocation;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;

@ThriftStruct
public class HiveFileInfo
implements Comparable {
    private final Path path;
    private final boolean isDirectory;
    private final List<BlockLocation> blockLocations;
    private final long length;
    private final long fileModifiedTime;
    private final Optional<byte[]> extraFileInfo;
    private final Map<String, String> customSplitInfo;

    public static HiveFileInfo createHiveFileInfo(LocatedFileStatus locatedFileStatus, Optional<byte[]> extraFileContext) throws IOException {
        return HiveFileInfo.createHiveFileInfo(locatedFileStatus, extraFileContext, (Map<String, String>)ImmutableMap.of());
    }

    public static HiveFileInfo createHiveFileInfo(LocatedFileStatus locatedFileStatus, Optional<byte[]> extraFileContext, Map<String, String> customSplitInfo) throws IOException {
        return new HiveFileInfo(locatedFileStatus.getPath().toString(), locatedFileStatus.isDirectory(), BlockLocation.fromHiveBlockLocations(locatedFileStatus.getBlockLocations()), locatedFileStatus.getLen(), locatedFileStatus.getModificationTime(), extraFileContext, customSplitInfo);
    }

    @ThriftConstructor
    public HiveFileInfo(String pathString, boolean directory, List<BlockLocation> blockLocations, long length, long fileModifiedTime, Optional<byte[]> extraFileInfo, Map<String, String> customSplitInfo) {
        this.path = new Path(Objects.requireNonNull(pathString, "pathString is null"));
        this.isDirectory = directory;
        this.blockLocations = Objects.requireNonNull(blockLocations, "blockLocations is null");
        this.length = length;
        this.fileModifiedTime = fileModifiedTime;
        this.extraFileInfo = Objects.requireNonNull(extraFileInfo, "extraFileInfo is null");
        this.customSplitInfo = Objects.requireNonNull(customSplitInfo, "customSplitInfo is null");
    }

    @ThriftField(value=1)
    public String getPathString() {
        return this.path.toString();
    }

    @ThriftField(value=2)
    public boolean isDirectory() {
        return this.isDirectory;
    }

    @ThriftField(value=3)
    public List<BlockLocation> getBlockLocations() {
        return this.blockLocations;
    }

    @ThriftField(value=4)
    public long getLength() {
        return this.length;
    }

    @ThriftField(value=5)
    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    @ThriftField(value=6)
    public Optional<byte[]> getExtraFileInfo() {
        return this.extraFileInfo;
    }

    @ThriftField(value=7)
    public Map<String, String> getCustomSplitInfo() {
        return this.customSplitInfo;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveFileInfo that = (HiveFileInfo)o;
        return this.path.equals((Object)that.path) && this.blockLocations.equals(that.blockLocations) && this.length == that.length;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.blockLocations, this.length);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("isDirectory", this.isDirectory).add("blockLocations", this.blockLocations).add("length", this.length).add("fileModifiedTime", this.fileModifiedTime).add("customSplitInfo", this.customSplitInfo).toString();
    }

    public int compareTo(Object o) {
        HiveFileInfo other = (HiveFileInfo)o;
        return this.getPath().compareTo((Object)other.getPath());
    }
}

