/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ComparisonChain;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PartitionNameWithVersion
implements Comparable<PartitionNameWithVersion> {
    private final String partitionName;
    private final Optional<Long> partitionVersion;

    @JsonCreator
    public PartitionNameWithVersion(@JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="partitionVersion") Optional<Long> partitionVersion) {
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.partitionVersion = Objects.requireNonNull(partitionVersion, "partitionVersion is null");
    }

    @JsonProperty
    public String getPartitionName() {
        return this.partitionName;
    }

    @JsonProperty
    public Optional<Long> getPartitionVersion() {
        return this.partitionVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionNameWithVersion{");
        sb.append("partitionName='").append(this.partitionName).append('\'');
        sb.append(", partitionVersion=").append(this.partitionVersion);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionNameWithVersion that = (PartitionNameWithVersion)o;
        return Objects.equals(this.partitionName, that.partitionName) && Objects.equals(this.partitionVersion, that.partitionVersion);
    }

    public int hashCode() {
        return Objects.hash(this.partitionName, this.partitionVersion);
    }

    @Override
    public int compareTo(PartitionNameWithVersion other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.partitionName), (Comparable)((Object)other.partitionName)).compare((Comparable)this.partitionVersion.orElse(Long.MIN_VALUE), (Comparable)other.partitionVersion.orElse(Long.MIN_VALUE)).result();
    }
}

