/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.hive.HiveCommonClientConfig;
import com.facebook.presto.orc.OrcWriteValidation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;

public class HiveCommonSessionProperties {
    @VisibleForTesting
    public static final String RANGE_FILTERS_ON_SUBSCRIPTS_ENABLED = "range_filters_on_subscripts_enabled";
    @VisibleForTesting
    public static final String PARQUET_BATCH_READ_OPTIMIZATION_ENABLED = "parquet_batch_read_optimization_enabled";
    private static final String NODE_SELECTION_STRATEGY = "node_selection_strategy";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_OPTIMIZED_WRITER_ENABLED = "orc_optimized_writer_enabled";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE = "orc_optimized_writer_validate";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_MODE = "orc_optimized_writer_validate_mode";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE = "orc_optimized_writer_validate_percentage";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_TINY_STRIPE_THRESHOLD = "orc_tiny_stripe_threshold";
    private static final String ORC_ZSTD_JNI_DECOMPRESSION_ENABLED = "orc_zstd_jni_decompression_enabled";
    private static final String PARQUET_BATCH_READER_VERIFICATION_ENABLED = "parquet_batch_reader_verification_enabled";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_USE_COLUMN_NAMES = "parquet_use_column_names";
    public static final String READ_MASKED_VALUE_ENABLED = "read_null_masked_parquet_encrypted_value_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public HiveCommonSessionProperties(HiveCommonClientConfig hiveCommonClientConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)RANGE_FILTERS_ON_SUBSCRIPTS_ENABLED, (String)"Experimental: enable pushdown of range filters on subscripts (a[2] = 5) into ORC column readers", (Boolean)hiveCommonClientConfig.isRangeFiltersOnSubscriptsEnabled(), (boolean)false), (Object)new PropertyMetadata(NODE_SELECTION_STRATEGY, "Node affinity selection strategy", (Type)VarcharType.VARCHAR, NodeSelectionStrategy.class, (Object)hiveCommonClientConfig.getNodeSelectionStrategy(), false, value -> NodeSelectionStrategy.valueOf((String)((String)value)), Enum::toString), (Object)PropertyMetadata.booleanProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)hiveCommonClientConfig.isOrcBloomFiltersEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)hiveCommonClientConfig.isOrcLazyReadSmallRanges(), (boolean)false), HiveCommonSessionProperties.dataSizeSessionProperty(ORC_MAX_BUFFER_SIZE, "ORC: Maximum size of a single read", hiveCommonClientConfig.getOrcMaxBufferSize(), false), HiveCommonSessionProperties.dataSizeSessionProperty(ORC_MAX_MERGE_DISTANCE, "ORC: Maximum size of gap between two reads to merge into a single read", hiveCommonClientConfig.getOrcMaxMergeDistance(), false), HiveCommonSessionProperties.dataSizeSessionProperty(ORC_MAX_READ_BLOCK_SIZE, "ORC: Soft max size of Presto blocks produced by ORC reader", hiveCommonClientConfig.getOrcMaxReadBlockSize(), false), (Object)PropertyMetadata.booleanProperty((String)ORC_OPTIMIZED_WRITER_ENABLED, (String)"Experimental: ORC: Enable optimized writer", (Boolean)hiveCommonClientConfig.isOrcOptimizedWriterEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: ORC: Force all validation for files", (Boolean)(hiveCommonClientConfig.getOrcWriterValidationPercentage() > 0.0 ? 1 : 0), (boolean)false), (Object)PropertyMetadata.stringProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE_MODE, (String)"Experimental: ORC: Level of detail in ORC validation", (String)hiveCommonClientConfig.getOrcWriterValidationMode().toString(), (boolean)false), (Object)new PropertyMetadata(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, "Experimental: ORC: sample percentage for validation for files", (Type)DoubleType.DOUBLE, Double.class, (Object)hiveCommonClientConfig.getOrcWriterValidationPercentage(), false, value -> {
            double doubleValue = ((Number)value).doubleValue();
            if (doubleValue < 0.0 || doubleValue > 100.0) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 0.0 and 100.0 inclusive: %s", ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, doubleValue));
            }
            return doubleValue;
        }, value -> value), HiveCommonSessionProperties.dataSizeSessionProperty(ORC_STREAM_BUFFER_SIZE, "ORC: Size of buffer for streaming reads", hiveCommonClientConfig.getOrcStreamBufferSize(), false), (Object[])new PropertyMetadata[]{HiveCommonSessionProperties.dataSizeSessionProperty(ORC_TINY_STRIPE_THRESHOLD, "ORC: Threshold below which an ORC stripe or file will read in its entirety", hiveCommonClientConfig.getOrcTinyStripeThreshold(), false), PropertyMetadata.booleanProperty((String)ORC_ZSTD_JNI_DECOMPRESSION_ENABLED, (String)"use JNI based zstd decompression for reading ORC files", (Boolean)hiveCommonClientConfig.isZstdJniDecompressionEnabled(), (boolean)true), PropertyMetadata.booleanProperty((String)PARQUET_BATCH_READ_OPTIMIZATION_ENABLED, (String)"Is Parquet batch read optimization enabled", (Boolean)hiveCommonClientConfig.isParquetBatchReadOptimizationEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_BATCH_READER_VERIFICATION_ENABLED, (String)"Is Parquet batch reader verification enabled? This is for testing purposes only, not to be used in production", (Boolean)hiveCommonClientConfig.isParquetBatchReaderVerificationEnabled(), (boolean)false), HiveCommonSessionProperties.dataSizeSessionProperty(PARQUET_MAX_READ_BLOCK_SIZE, "Parquet: Maximum size of a block to read", hiveCommonClientConfig.getParquetMaxReadBlockSize(), false), PropertyMetadata.booleanProperty((String)PARQUET_USE_COLUMN_NAMES, (String)"Experimental: Parquet: Access Parquet columns using names from the file", (Boolean)hiveCommonClientConfig.isUseParquetColumnNames(), (boolean)false), PropertyMetadata.booleanProperty((String)READ_MASKED_VALUE_ENABLED, (String)"Return null when access is denied for an encrypted parquet column", (Boolean)hiveCommonClientConfig.getReadNullMaskedParquetEncryptedValue(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static NodeSelectionStrategy getNodeSelectionStrategy(ConnectorSession session) {
        return (NodeSelectionStrategy)session.getProperty(NODE_SELECTION_STRATEGY, NodeSelectionStrategy.class);
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean isOrcOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static boolean isOrcOptimizedWriterValidate(ConnectorSession session) {
        boolean validate = (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
        double percentage = (Double)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, Double.class);
        Preconditions.checkArgument((percentage >= 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        if (!validate) {
            return false;
        }
        return ThreadLocalRandom.current().nextDouble(100.0) < percentage;
    }

    public static OrcWriteValidation.OrcWriteValidationMode getOrcOptimizedWriterValidateMode(ConnectorSession session) {
        return OrcWriteValidation.OrcWriteValidationMode.valueOf((String)((String)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_MODE, String.class)).toUpperCase(Locale.ENGLISH));
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcTinyStripeThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_TINY_STRIPE_THRESHOLD, DataSize.class);
    }

    public static boolean isOrcZstdJniDecompressionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_ZSTD_JNI_DECOMPRESSION_ENABLED, Boolean.class);
    }

    public static boolean isParquetBatchReadsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_BATCH_READ_OPTIMIZATION_ENABLED, Boolean.class);
    }

    public static boolean isParquetBatchReaderVerificationEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_BATCH_READER_VERIFICATION_ENABLED, Boolean.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean isUseParquetColumnNames(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_COLUMN_NAMES, Boolean.class);
    }

    public static boolean isRangeFiltersOnSubscriptsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(RANGE_FILTERS_ON_SUBSCRIPTS_ENABLED, Boolean.class);
    }

    public static boolean getReadNullMaskedParquetEncryptedValue(ConnectorSession session) {
        return (Boolean)session.getProperty(READ_MASKED_VALUE_ENABLED, Boolean.class);
    }

    public static PropertyMetadata<DataSize> dataSizeSessionProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.createUnboundedVarcharType(), DataSize.class, (Object)defaultValue, hidden, value -> DataSize.valueOf((String)((String)value)), DataSize::toString);
    }
}

