/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.hive.BaseHiveTableLayoutHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.hive.rule.FilterPushdownUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class MetadataUtils {
    private MetadataUtils() {
    }

    public static Optional<DiscretePredicates> getDiscretePredicates(List<ColumnHandle> partitionColumns, List<HivePartition> partitions) {
        Optional<DiscretePredicates> discretePredicates = Optional.empty();
        if (!(partitionColumns.isEmpty() || partitions.size() == 1 && partitions.get(0).getPartitionId().equals(HivePartition.UNPARTITIONED_ID))) {
            Iterable partitionDomains = Iterables.transform(partitions, hivePartition -> TupleDomain.fromFixedValues(hivePartition.getKeys()));
            discretePredicates = Optional.of(new DiscretePredicates(partitionColumns, partitionDomains));
        }
        return discretePredicates;
    }

    public static TupleDomain<ColumnHandle> getPredicate(BaseHiveTableLayoutHandle layoutHandle, List<ColumnHandle> partitionColumns, List<HivePartition> partitions, Map<String, ColumnHandle> predicateColumns) {
        TupleDomain predicate = layoutHandle.getDomainPredicate().transform(subfield -> FilterPushdownUtils.isEntireColumn(subfield) ? subfield.getRootName() : null).transform(predicateColumns::get).intersect(MetadataUtils.createPredicate(partitionColumns, partitions));
        return predicate;
    }

    public static RowExpression getSubfieldPredicate(ConnectorSession session, BaseHiveTableLayoutHandle layoutHandle, Map<String, Type> columnTypes, StandardFunctionResolution functionResolution, RowExpressionService rowExpressionService) {
        SubfieldExtractor subfieldExtractor = new SubfieldExtractor(functionResolution, rowExpressionService.getExpressionOptimizer(), session);
        return rowExpressionService.getDomainTranslator().toPredicate(layoutHandle.getDomainPredicate().transform(subfield -> !FilterPushdownUtils.isEntireColumn(subfield) ? subfield : null).transform(subfield -> subfieldExtractor.toRowExpression((Subfield)subfield, (Type)columnTypes.get(subfield.getRootName()))));
    }

    public static RowExpression getCombinedRemainingPredicate(BaseHiveTableLayoutHandle layoutHandle, RowExpression subfieldPredicate) {
        List predicatesToCombine = (List)ImmutableList.of((Object)subfieldPredicate, (Object)layoutHandle.getRemainingPredicate()).stream().filter(p -> !p.equals((Object)LogicalRowExpressions.TRUE_CONSTANT)).collect(ImmutableList.toImmutableList());
        return LogicalRowExpressions.binaryExpression((SpecialFormExpression.Form)SpecialFormExpression.Form.AND, (Collection)predicatesToCombine);
    }

    @VisibleForTesting
    public static TupleDomain<ColumnHandle> createPredicate(List<ColumnHandle> partitionColumns, List<HivePartition> partitions) {
        if (partitions.isEmpty()) {
            return TupleDomain.none();
        }
        if (partitions.size() == 1 && partitions.get(0).getPartitionId().equals(HivePartition.UNPARTITIONED_ID)) {
            return TupleDomain.all();
        }
        return TupleDomain.withColumnDomains(partitionColumns.stream().collect(Collectors.toMap(Function.identity(), column -> MetadataUtils.buildColumnDomain(column, partitions))));
    }

    private static Domain buildColumnDomain(ColumnHandle column, List<HivePartition> partitions) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"partitions cannot be empty");
        boolean hasNull = false;
        HashSet<Object> nonNullValues = new HashSet<Object>();
        Type type = null;
        for (HivePartition partition : partitions) {
            NullableValue value = partition.getKeys().get(column);
            if (value == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, String.format("Partition %s does not have a value for partition column %s", partition, column));
            }
            if (value.isNull()) {
                hasNull = true;
            } else {
                nonNullValues.add(value.getValue());
            }
            if (type != null) continue;
            type = value.getType();
        }
        if (!nonNullValues.isEmpty()) {
            Domain domain = Domain.multipleValues(type, (List)ImmutableList.copyOf(nonNullValues));
            if (hasNull) {
                return domain.union(Domain.onlyNull(type));
            }
            return domain;
        }
        return Domain.onlyNull(type);
    }
}

