/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.aws.security;

import com.facebook.presto.hive.aws.security.BasicAWSCredentials;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class AWSSecurityMapping {
    private final Predicate<String> user;
    private final Optional<String> iamRole;
    private final Optional<BasicAWSCredentials> credentials;

    @JsonCreator
    public AWSSecurityMapping(@JsonProperty(value="user") Optional<Pattern> user, @JsonProperty(value="iamRole") Optional<String> iamRole, @JsonProperty(value="accessKey") Optional<String> accessKey, @JsonProperty(value="secretKey") Optional<String> secretKey) {
        this.user = Objects.requireNonNull(user, "user is null").map(AWSSecurityMapping::toPredicate).orElse(x -> true);
        this.iamRole = Objects.requireNonNull(iamRole, "iamRole is null");
        Objects.requireNonNull(accessKey, "accessKey is null");
        Objects.requireNonNull(secretKey, "secretKey is null");
        Preconditions.checkArgument((accessKey.isPresent() == secretKey.isPresent() ? 1 : 0) != 0, (Object)"accessKey and secretKey must be provided together");
        this.credentials = accessKey.map(access -> new BasicAWSCredentials((String)access, (String)secretKey.get()));
    }

    public boolean matches(String user) {
        return this.user.test(user);
    }

    public Optional<String> getIamRole() {
        return this.iamRole;
    }

    public Optional<BasicAWSCredentials> getCredentials() {
        return this.credentials;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", this.user).add("iamRole", this.iamRole).add("credentials", this.credentials).toString();
    }

    private static Predicate<String> toPredicate(Pattern pattern) {
        return value -> pattern.matcher((CharSequence)value).matches();
    }
}

