/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.aws.security;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.hive.aws.security.AWSSecurityMappingType;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.AssertTrue;

public class AWSSecurityMappingConfig {
    private static final String MAPPING_TYPE = "hive.aws.security-mapping.type";
    private static final String CONFIG_FILE = "hive.aws.security-mapping.config-file";
    private static final String REFRESH_PERIOD = "hive.aws.security-mapping.refresh-period";
    private AWSSecurityMappingType mappingType;
    private File configFile;
    private Duration refreshPeriod = new Duration(30.0, TimeUnit.SECONDS);

    public AWSSecurityMappingType getMappingType() {
        return this.mappingType;
    }

    @Config(value="hive.aws.security-mapping.type")
    @ConfigDescription(value="AWS Security Mapping Type. Possible values: S3 or LAKEFORMATION")
    public AWSSecurityMappingConfig setMappingType(AWSSecurityMappingType mappingType) {
        this.mappingType = mappingType;
        return this;
    }

    public Optional<File> getConfigFile() {
        return Optional.ofNullable(this.configFile);
    }

    @Nullable
    @Config(value="hive.aws.security-mapping.config-file")
    @ConfigDescription(value="JSON configuration file containing AWS IAM Security mappings")
    public AWSSecurityMappingConfig setConfigFile(File configFile) {
        this.configFile = configFile;
        return this;
    }

    public Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }

    @MinDuration(value="0ms")
    @Config(value="hive.aws.security-mapping.refresh-period")
    @ConfigDescription(value="Time interval after which AWS IAM security mapping configuration will be refreshed")
    public AWSSecurityMappingConfig setRefreshPeriod(Duration refreshPeriod) {
        this.refreshPeriod = Objects.requireNonNull(refreshPeriod, "refreshPeriod is null");
        return this;
    }

    @AssertTrue(message="MAPPING TYPE(hive.aws.security-mapping.type) must be configured when AWS Security Mapping Config File(hive.aws.security-mapping.config-file) is set and vice versa")
    public @AssertTrue(message="MAPPING TYPE(hive.aws.security-mapping.type) must be configured when AWS Security Mapping Config File(hive.aws.security-mapping.config-file) is set and vice versa") boolean isValidConfiguration() {
        return this.getConfigFile().isPresent() && this.getMappingType() != null || !this.getConfigFile().isPresent() && this.getMappingType() == null;
    }
}

