/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.aws.security;

import com.facebook.presto.hive.aws.security.AWSSecurityMapping;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class AWSSecurityMappings {
    private final List<AWSSecurityMapping> awsSecurityMappings;

    @JsonCreator
    public AWSSecurityMappings(@JsonProperty(value="mappings") List<AWSSecurityMapping> awsSecurityMappings) {
        Preconditions.checkArgument((awsSecurityMappings != null ? 1 : 0) != 0, (Object)"No AWS Security mappings configured");
        this.awsSecurityMappings = ImmutableList.copyOf(awsSecurityMappings);
    }

    public AWSSecurityMapping getAWSLakeFormationSecurityMapping(String user) {
        Optional<AWSSecurityMapping> awsSecurityMapping = this.awsSecurityMappings.stream().filter(mapping -> mapping.matches(user)).findFirst();
        if (!awsSecurityMapping.isPresent()) {
            throw new AccessDeniedException("No matching AWS Lake Formation Security Mapping");
        }
        Verify.verify((!awsSecurityMapping.get().getCredentials().isPresent() ? 1 : 0) != 0, (String)"Basic AWS Credentials are not supported for AWS Lake Formation Security Mapping", (Object[])new Object[0]);
        Verify.verify((boolean)awsSecurityMapping.get().getIamRole().isPresent(), (String)"iamRole is mandatory for AWS Lake Formation Security Mapping", (Object[])new Object[0]);
        return awsSecurityMapping.get();
    }

    public AWSSecurityMapping getAWSS3SecurityMapping(String user) {
        Optional<AWSSecurityMapping> awsSecurityMapping = this.awsSecurityMappings.stream().filter(mapping -> mapping.matches(user)).findFirst();
        return awsSecurityMapping.orElseThrow(() -> new AccessDeniedException("No matching AWS S3 Security Mapping"));
    }
}

