/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.aws.security;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.hive.aws.security.AWSSecurityMappings;
import com.facebook.presto.plugin.base.JsonUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.airlift.units.Duration;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class AWSSecurityMappingsSupplier {
    private static final Logger log = Logger.get(AWSSecurityMappingsSupplier.class);
    private final Supplier<AWSSecurityMappings> mappingsSupplier;

    public AWSSecurityMappingsSupplier(Optional<File> configFile, Duration refreshPeriod) {
        Objects.requireNonNull(configFile, "configFile is null");
        Objects.requireNonNull(refreshPeriod, "refreshPeriod is null");
        this.mappingsSupplier = AWSSecurityMappingsSupplier.getMappings(configFile, refreshPeriod);
    }

    private static Supplier<AWSSecurityMappings> getMappings(Optional<File> configFile, Duration refreshPeriod) {
        if (!configFile.isPresent()) {
            return null;
        }
        Preconditions.checkArgument((configFile.get().exists() && configFile.get().isFile() ? 1 : 0) != 0, (String)"AWS Security Mapping config file does not exist: %s", (Object)configFile.get());
        Supplier<AWSSecurityMappings> supplier = () -> (AWSSecurityMappings)JsonUtils.parseJson((Path)((File)configFile.get()).toPath(), AWSSecurityMappings.class);
        return Suppliers.memoizeWithExpiration(() -> {
            log.debug("Refreshing AWS security mapping configuration from %s", new Object[]{configFile});
            return (AWSSecurityMappings)supplier.get();
        }, (long)refreshPeriod.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Supplier<AWSSecurityMappings> getMappingsSupplier() {
        return this.mappingsSupplier;
    }
}

