/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rule;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.expressions.DynamicFilters;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.expressions.RowExpressionNodeInliner;
import com.facebook.presto.hive.BaseHiveTableLayoutHandle;
import com.facebook.presto.hive.HiveWarningCode;
import com.facebook.presto.hive.SubfieldExtractor;
import com.facebook.presto.hive.rule.FilterPushdownUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanRewriter;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public abstract class BaseSubfieldExtractionRewriter
extends ConnectorPlanRewriter<Void> {
    private static final ConnectorTableLayout EMPTY_TABLE_LAYOUT = new ConnectorTableLayout(new ConnectorTableLayoutHandle(){}, Optional.empty(), TupleDomain.none(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    protected final RowExpressionService rowExpressionService;
    protected final Function<TableHandle, ConnectorMetadata> transactionToMetadata;
    private final ConnectorSession session;
    private final PlanNodeIdAllocator idAllocator;
    private final StandardFunctionResolution functionResolution;
    private final FunctionMetadataManager functionMetadataManager;

    public BaseSubfieldExtractionRewriter(ConnectorSession session, PlanNodeIdAllocator idAllocator, RowExpressionService rowExpressionService, StandardFunctionResolution functionResolution, FunctionMetadataManager functionMetadataManager, Function<TableHandle, ConnectorMetadata> transactionToMetadata) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
        this.transactionToMetadata = transactionToMetadata;
    }

    public PlanNode visitFilter(FilterNode filter, ConnectorPlanRewriter.RewriteContext<Void> context) {
        if (!(filter.getSource() instanceof TableScanNode)) {
            return this.visitPlan((PlanNode)filter, context);
        }
        TableScanNode tableScan = (TableScanNode)filter.getSource();
        if (!this.isPushdownFilterSupported(this.session, tableScan.getTable())) {
            return filter;
        }
        RowExpression expression = filter.getPredicate();
        TableHandle handle = tableScan.getTable();
        ConnectorMetadata metadata = this.transactionToMetadata.apply(handle);
        BiMap symbolToColumnMapping = (BiMap)tableScan.getAssignments().entrySet().stream().collect(ImmutableBiMap.toImmutableBiMap(Map.Entry::getKey, entry -> new VariableReferenceExpression(Optional.empty(), BaseSubfieldExtractionRewriter.getColumnName(this.session, metadata, handle.getConnectorHandle(), (ColumnHandle)entry.getValue()), ((VariableReferenceExpression)entry.getKey()).getType())));
        RowExpression replacedExpression = RowExpressionNodeInliner.replaceExpression((RowExpression)expression, (Map)symbolToColumnMapping);
        if (LogicalRowExpressions.FALSE_CONSTANT.equals((Object)replacedExpression)) {
            return this.getValuesNode(tableScan);
        }
        ConnectorPushdownFilterResult pushdownFilterResult = this.pushdownFilter(this.session, metadata, handle.getConnectorHandle(), replacedExpression, handle.getLayout());
        ConnectorTableLayout layout = pushdownFilterResult.getLayout();
        if (layout.getPredicate().isNone()) {
            return this.getValuesNode(tableScan);
        }
        TableScanNode node = BaseSubfieldExtractionRewriter.getTableScanNode(tableScan, handle, pushdownFilterResult);
        RowExpression unenforcedFilter = pushdownFilterResult.getUnenforcedConstraint();
        if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)unenforcedFilter)) {
            return new FilterNode(tableScan.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)node, RowExpressionNodeInliner.replaceExpression((RowExpression)unenforcedFilter, (Map)symbolToColumnMapping.inverse()));
        }
        return node;
    }

    public PlanNode visitTableScan(TableScanNode tableScan, ConnectorPlanRewriter.RewriteContext<Void> context) {
        if (!this.isPushdownFilterSupported(this.session, tableScan.getTable())) {
            return tableScan;
        }
        TableHandle handle = tableScan.getTable();
        ConnectorMetadata metadata = this.transactionToMetadata.apply(handle);
        ConnectorPushdownFilterResult pushdownFilterResult = this.pushdownFilter(this.session, metadata, handle.getConnectorHandle(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT, handle.getLayout());
        if (pushdownFilterResult.getLayout().getPredicate().isNone()) {
            return this.getValuesNode(tableScan);
        }
        TableScanNode node = BaseSubfieldExtractionRewriter.getTableScanNode(tableScan, handle, pushdownFilterResult);
        RowExpression unenforcedFilter = pushdownFilterResult.getUnenforcedConstraint();
        if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)unenforcedFilter)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unenforced filter found %s but not handled", unenforcedFilter));
        }
        return node;
    }

    public ConnectorPushdownFilterResult pushdownFilter(ConnectorSession session, ConnectorMetadata metadata, ConnectorTableHandle tableHandle, RowExpression filter, Optional<ConnectorTableLayoutHandle> currentLayoutHandle) {
        ConstantExpression constantExpression;
        Preconditions.checkArgument((!LogicalRowExpressions.FALSE_CONSTANT.equals((Object)filter) ? 1 : 0) != 0, (Object)"Cannot pushdown filter that is always false");
        if (LogicalRowExpressions.TRUE_CONSTANT.equals((Object)filter) && currentLayoutHandle.isPresent()) {
            return new ConnectorPushdownFilterResult(metadata.getTableLayout(session, currentLayoutHandle.get()), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
        }
        DomainTranslator.ExtractionResult decomposedFilter = this.rowExpressionService.getDomainTranslator().fromPredicate(session, filter, new SubfieldExtractor(this.functionResolution, this.rowExpressionService.getExpressionOptimizer(), session).toColumnExtractor());
        if (currentLayoutHandle.isPresent()) {
            BaseHiveTableLayoutHandle currentHiveLayout = (BaseHiveTableLayoutHandle)currentLayoutHandle.get();
            decomposedFilter = BaseSubfieldExtractionRewriter.intersectExtractionResult(new DomainTranslator.ExtractionResult(currentHiveLayout.getDomainPredicate(), currentHiveLayout.getRemainingPredicate()), decomposedFilter);
        }
        if (decomposedFilter.getTupleDomain().isNone()) {
            return new ConnectorPushdownFilterResult(EMPTY_TABLE_LAYOUT, (RowExpression)LogicalRowExpressions.FALSE_CONSTANT);
        }
        RowExpression optimizedRemainingExpression = this.rowExpressionService.getExpressionOptimizer().optimize(decomposedFilter.getRemainingExpression(), ExpressionOptimizer.Level.OPTIMIZED, session);
        if (optimizedRemainingExpression instanceof ConstantExpression && (LogicalRowExpressions.FALSE_CONSTANT.equals((Object)(constantExpression = (ConstantExpression)optimizedRemainingExpression)) || constantExpression.getValue() == null)) {
            return new ConnectorPushdownFilterResult(EMPTY_TABLE_LAYOUT, (RowExpression)LogicalRowExpressions.FALSE_CONSTANT);
        }
        Map columnHandles = metadata.getColumnHandles(session, tableHandle);
        TupleDomain entireColumnDomain = decomposedFilter.getTupleDomain().transform(subfield -> FilterPushdownUtils.isEntireColumn(subfield) ? subfield.getRootName() : null).transform(columnHandles::get);
        if (currentLayoutHandle.isPresent()) {
            entireColumnDomain = entireColumnDomain.intersect(((BaseHiveTableLayoutHandle)currentLayoutHandle.get()).getPartitionColumnPredicate());
        }
        Constraint<ColumnHandle> constraint = new Constraint<ColumnHandle>(entireColumnDomain);
        constraint = this.extractDeterministicConjuncts(session, (DomainTranslator.ExtractionResult<Subfield>)decomposedFilter, columnHandles, (TupleDomain<ColumnHandle>)entireColumnDomain, constraint);
        RemainingExpressions remainingExpressions = this.getRemainingExpressions(tableHandle, (DomainTranslator.ExtractionResult<Subfield>)decomposedFilter, columnHandles);
        return this.getConnectorPushdownFilterResult(columnHandles, metadata, session, remainingExpressions, (DomainTranslator.ExtractionResult<Subfield>)decomposedFilter, optimizedRemainingExpression, constraint, currentLayoutHandle, tableHandle);
    }

    protected abstract ConnectorPushdownFilterResult getConnectorPushdownFilterResult(Map<String, ColumnHandle> var1, ConnectorMetadata var2, ConnectorSession var3, RemainingExpressions var4, DomainTranslator.ExtractionResult<Subfield> var5, RowExpression var6, Constraint<ColumnHandle> var7, Optional<ConnectorTableLayoutHandle> var8, ConnectorTableHandle var9);

    protected abstract boolean isPushdownFilterSupported(ConnectorSession var1, TableHandle var2);

    private static String getColumnName(ConnectorSession session, ConnectorMetadata metadata, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return metadata.getColumnMetadata(session, tableHandle, columnHandle).getName();
    }

    private static TableScanNode getTableScanNode(TableScanNode tableScan, TableHandle handle, ConnectorPushdownFilterResult pushdownFilterResult) {
        return new TableScanNode(tableScan.getSourceLocation(), tableScan.getId(), new TableHandle(handle.getConnectorId(), handle.getConnectorHandle(), handle.getTransaction(), Optional.of(pushdownFilterResult.getLayout().getHandle())), tableScan.getOutputVariables(), tableScan.getAssignments(), tableScan.getTableConstraints(), pushdownFilterResult.getLayout().getPredicate(), TupleDomain.all());
    }

    private static DomainTranslator.ExtractionResult intersectExtractionResult(DomainTranslator.ExtractionResult left, DomainTranslator.ExtractionResult right) {
        RowExpression newRemainingExpression = right.getRemainingExpression().equals((Object)LogicalRowExpressions.TRUE_CONSTANT) ? left.getRemainingExpression() : (left.getRemainingExpression().equals((Object)LogicalRowExpressions.TRUE_CONSTANT) ? right.getRemainingExpression() : LogicalRowExpressions.and((RowExpression[])new RowExpression[]{left.getRemainingExpression(), right.getRemainingExpression()}));
        return new DomainTranslator.ExtractionResult(left.getTupleDomain().intersect(right.getTupleDomain()), newRemainingExpression);
    }

    private Constraint<ColumnHandle> extractDeterministicConjuncts(ConnectorSession session, DomainTranslator.ExtractionResult<Subfield> decomposedFilter, Map<String, ColumnHandle> columnHandles, TupleDomain<ColumnHandle> entireColumnDomain, Constraint<ColumnHandle> constraint) {
        LogicalRowExpressions logicalRowExpressions;
        RowExpression deterministicPredicate;
        if (!LogicalRowExpressions.TRUE_CONSTANT.equals((Object)decomposedFilter.getRemainingExpression()) && !LogicalRowExpressions.TRUE_CONSTANT.equals((Object)(deterministicPredicate = (logicalRowExpressions = new LogicalRowExpressions(this.rowExpressionService.getDeterminismEvaluator(), this.functionResolution, this.functionMetadataManager)).filterDeterministicConjuncts(decomposedFilter.getRemainingExpression())))) {
            ConstraintEvaluator evaluator = new ConstraintEvaluator(this.rowExpressionService, session, columnHandles, deterministicPredicate);
            constraint = new Constraint(entireColumnDomain, x$0 -> evaluator.isCandidate(x$0));
        }
        return constraint;
    }

    private ValuesNode getValuesNode(TableScanNode tableScan) {
        this.session.getWarningCollector().add(new PrestoWarning((WarningCodeSupplier)HiveWarningCode.HIVE_TABLESCAN_CONVERTED_TO_VALUESNODE, String.format("Table '%s' returns 0 rows, and is converted to an empty %s by %s", tableScan.getTable().getConnectorHandle(), ValuesNode.class.getSimpleName(), BaseSubfieldExtractionRewriter.class.getSimpleName())));
        return new ValuesNode(tableScan.getSourceLocation(), this.idAllocator.getNextId(), tableScan.getOutputVariables(), (List)ImmutableList.of(), Optional.of(tableScan.getTable().getConnectorHandle().toString()));
    }

    private RemainingExpressions getRemainingExpressions(ConnectorTableHandle tableHandle, DomainTranslator.ExtractionResult<Subfield> decomposedFilter, Map<String, ColumnHandle> columnHandles) {
        LogicalRowExpressions logicalRowExpressions = new LogicalRowExpressions(this.rowExpressionService.getDeterminismEvaluator(), this.functionResolution, this.functionMetadataManager);
        List conjuncts = LogicalRowExpressions.extractConjuncts((RowExpression)decomposedFilter.getRemainingExpression());
        ImmutableList.Builder dynamicConjuncts = ImmutableList.builder();
        ImmutableList.Builder staticConjuncts = ImmutableList.builder();
        for (RowExpression conjunct : conjuncts) {
            if (DynamicFilters.isDynamicFilter((RowExpression)conjunct) || this.useDynamicFilter(conjunct, tableHandle, columnHandles)) {
                dynamicConjuncts.add((Object)conjunct);
                continue;
            }
            staticConjuncts.add((Object)conjunct);
        }
        RowExpression dynamicFilterExpression = logicalRowExpressions.combineConjuncts((Collection)dynamicConjuncts.build());
        RowExpression remainingExpression = logicalRowExpressions.combineConjuncts((Collection)staticConjuncts.build());
        remainingExpression = DynamicFilters.removeNestedDynamicFilters((RowExpression)remainingExpression);
        return new RemainingExpressions(dynamicFilterExpression, remainingExpression);
    }

    protected static Set<VariableReferenceExpression> extractVariableExpressions(RowExpression expression) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        expression.accept((RowExpressionVisitor)new VariableReferenceBuilderVisitor(), (Object)builder);
        return builder.build();
    }

    public boolean useDynamicFilter(RowExpression expression, ConnectorTableHandle tableHandle, Map<String, ColumnHandle> columnHandleMap) {
        return false;
    }

    public static class RemainingExpressions {
        public final RowExpression dynamicFilterExpression;
        public final RowExpression remainingExpression;

        public RemainingExpressions(RowExpression dynamicFilterExpression, RowExpression remainingExpression) {
            this.dynamicFilterExpression = dynamicFilterExpression;
            this.remainingExpression = remainingExpression;
        }

        public RowExpression getDynamicFilterExpression() {
            return this.dynamicFilterExpression;
        }

        public RowExpression getRemainingExpression() {
            return this.remainingExpression;
        }
    }

    public static class ConnectorPushdownFilterResult {
        private final ConnectorTableLayout layout;
        private final RowExpression unenforcedConstraint;

        public ConnectorPushdownFilterResult(ConnectorTableLayout layout, RowExpression unenforcedConstraint) {
            this.layout = Objects.requireNonNull(layout, "layout is null");
            this.unenforcedConstraint = Objects.requireNonNull(unenforcedConstraint, "unenforcedConstraint is null");
        }

        public ConnectorTableLayout getLayout() {
            return this.layout;
        }

        public RowExpression getUnenforcedConstraint() {
            return this.unenforcedConstraint;
        }
    }

    private static class VariableReferenceBuilderVisitor
    extends DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<VariableReferenceExpression>> {
        private VariableReferenceBuilderVisitor() {
        }

        public Void visitVariableReference(VariableReferenceExpression variable, ImmutableSet.Builder<VariableReferenceExpression> builder) {
            builder.add((Object)variable);
            return null;
        }
    }

    private static class ConstraintEvaluator {
        private final Map<String, ColumnHandle> assignments;
        private final RowExpressionService evaluator;
        private final ConnectorSession session;
        private final RowExpression expression;
        private final Set<ColumnHandle> arguments;

        public ConstraintEvaluator(RowExpressionService evaluator, ConnectorSession session, Map<String, ColumnHandle> assignments, RowExpression expression) {
            this.assignments = assignments;
            this.evaluator = evaluator;
            this.session = session;
            this.expression = expression;
            this.arguments = (Set)ImmutableSet.copyOf(BaseSubfieldExtractionRewriter.extractVariableExpressions(expression)).stream().map(VariableReferenceExpression::getName).map(assignments::get).collect(ImmutableSet.toImmutableSet());
        }

        private boolean isCandidate(Map<ColumnHandle, NullableValue> bindings) {
            if (Sets.intersection(bindings.keySet(), this.arguments).isEmpty()) {
                return true;
            }
            Function<VariableReferenceExpression, Object> variableResolver = variable -> {
                ColumnHandle column = this.assignments.get(variable.getName());
                Preconditions.checkArgument((column != null ? 1 : 0) != 0, (String)"Missing column assignment for %s", (Object)variable);
                if (!bindings.containsKey(column)) {
                    return variable;
                }
                return ((NullableValue)bindings.get(column)).getValue();
            };
            Object optimized = null;
            try {
                optimized = this.evaluator.getExpressionOptimizer().optimize(this.expression, ExpressionOptimizer.Level.OPTIMIZED, this.session, variableResolver);
            }
            catch (PrestoException e) {
                ConstraintEvaluator.propagateIfUnhandled(e);
                return true;
            }
            return !Boolean.FALSE.equals(optimized) && optimized != null && (!(optimized instanceof ConstantExpression) || !((ConstantExpression)optimized).isNull());
        }

        private static void propagateIfUnhandled(PrestoException e) throws PrestoException {
            int errorCode = e.getErrorCode().getCode();
            if (errorCode == StandardErrorCode.DIVISION_BY_ZERO.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode().getCode()) {
                return;
            }
            throw e;
        }
    }
}

