/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rule;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.hive.BaseHiveColumnHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FilterPushdownUtils {
    private FilterPushdownUtils() {
    }

    public static TupleDomain<Subfield> getDomainPredicate(DomainTranslator.ExtractionResult<Subfield> decomposedFilter, TupleDomain<ColumnHandle> unenforcedConstraint) {
        return TupleDomain.withColumnDomains((Map)ImmutableMap.builder().putAll((Map)unenforcedConstraint.transform(columnHandle -> new Subfield(((BaseHiveColumnHandle)columnHandle).getName(), (List)ImmutableList.of())).getDomains().orElse(ImmutableMap.of())).putAll((Map)decomposedFilter.getTupleDomain().transform(subfield -> !FilterPushdownUtils.isEntireColumn(subfield) ? subfield : null).getDomains().orElse(ImmutableMap.of())).build());
    }

    public static Set<String> getPredicateColumnNames(RowExpression optimizedRemainingExpression, TupleDomain<Subfield> domainPredicate) {
        HashSet<String> predicateColumnNames = new HashSet<String>();
        ((Map)domainPredicate.getDomains().get()).keySet().stream().map(Subfield::getRootName).forEach(predicateColumnNames::add);
        FilterPushdownUtils.extractVariableExpressions(optimizedRemainingExpression).stream().map(VariableReferenceExpression::getName).forEach(predicateColumnNames::add);
        return predicateColumnNames;
    }

    public static boolean isEntireColumn(Subfield subfield) {
        return subfield.getPath().isEmpty();
    }

    private static Set<VariableReferenceExpression> extractVariableExpressions(RowExpression expression) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        expression.accept((RowExpressionVisitor)new VariableReferenceBuilderVisitor(), (Object)builder);
        return builder.build();
    }

    private static class VariableReferenceBuilderVisitor
    extends DefaultRowExpressionTraversalVisitor<ImmutableSet.Builder<VariableReferenceExpression>> {
        private VariableReferenceBuilderVisitor() {
        }

        public Void visitVariableReference(VariableReferenceExpression variable, ImmutableSet.Builder<VariableReferenceExpression> builder) {
            builder.add((Object)variable);
            return null;
        }
    }
}

