/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.aggregation;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorInvoker;
import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorState;
import com.facebook.presto.hive.functions.gen.CompilerUtils;
import com.facebook.presto.hive.functions.type.BlockInputDecoder;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class HiveAccumulatorMethodHandles {
    private static final String INPUT_FUNCTION_CLASS = "HiveAggregationInputFunction";
    private static final String INPUT_FUNCTION_METHOD = "input";
    private static final MethodHandle COMBINE = MethodHandleUtil.methodHandle(HiveAccumulatorMethodHandles.class, (String)"combine", (Class[])new Class[]{HiveAccumulatorInvoker.class, HiveAccumulatorState.class, HiveAccumulatorState.class});
    private static final MethodHandle OUTPUT = MethodHandleUtil.methodHandle(HiveAccumulatorMethodHandles.class, (String)"output", (Class[])new Class[]{HiveAccumulatorInvoker.class, HiveAccumulatorState.class, BlockBuilder.class});

    private HiveAccumulatorMethodHandles() {
    }

    public static MethodHandle getInputFunction(HiveAccumulatorInvoker context, List<BlockInputDecoder> decoders) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(decoders);
        MethodHandle methodHandle = HiveAccumulatorMethodHandles.generateUnboundInputFunction(decoders.size());
        methodHandle = methodHandle.bindTo(context);
        for (BlockInputDecoder decoder : decoders) {
            methodHandle = methodHandle.bindTo(decoder);
        }
        return methodHandle;
    }

    public static MethodHandle getCombineFunction(HiveAccumulatorInvoker context) {
        return COMBINE.bindTo(Objects.requireNonNull(context));
    }

    public static MethodHandle getOutputFunction(HiveAccumulatorInvoker context) {
        return OUTPUT.bindTo(Objects.requireNonNull(context));
    }

    public static MethodHandle generateUnboundInputFunction(int numInputs) {
        ClassDefinition classDefinition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(INPUT_FUNCTION_CLASS), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        classDefinition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        Parameter invokerParameter = Parameter.arg((String)"invoker", HiveAccumulatorInvoker.class);
        List decoderParameters = IntStream.range(0, numInputs).mapToObj(i -> Parameter.arg((String)("decoder_" + i), BlockInputDecoder.class)).collect(Collectors.toList());
        Parameter stateParameter = Parameter.arg((String)"state", HiveAccumulatorState.class);
        List blockParameters = IntStream.range(0, numInputs).mapToObj(i -> Parameter.arg((String)("input_" + i), Block.class)).collect(Collectors.toList());
        Parameter positionParameter = Parameter.arg((String)"position", Integer.TYPE);
        ArrayList<Object> parameters = new ArrayList<Object>(2 * numInputs + 3);
        parameters.add(invokerParameter);
        parameters.addAll(decoderParameters);
        parameters.add(stateParameter);
        parameters.addAll(blockParameters);
        parameters.add(positionParameter);
        MethodDefinition methodDefinition = classDefinition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), INPUT_FUNCTION_METHOD, ParameterizedType.type(Void.TYPE), parameters.toArray(new Parameter[0]));
        BytecodeExpression[] decoded = (BytecodeExpression[])IntStream.range(0, numInputs).mapToObj(i -> ((Parameter)decoderParameters.get(i)).invoke("decode", Object.class, new BytecodeExpression[]{(BytecodeExpression)blockParameters.get(i), positionParameter})).toArray(BytecodeExpression[]::new);
        methodDefinition.getBody().append((BytecodeNode)invokerParameter.invoke("iterate", Void.TYPE, new BytecodeExpression[]{stateParameter, BytecodeExpressions.newArray((ParameterizedType)ParameterizedType.type(Object[].class), (BytecodeExpression[])decoded)}).ret());
        Class<Object> generatedClass = CompilerUtils.defineClass(classDefinition, Object.class, Collections.emptyMap(), HiveAccumulatorMethodHandles.class.getClassLoader());
        ArrayList<Class<Integer>> parameterClasses = new ArrayList<Class<Integer>>(parameters.size());
        parameterClasses.add(HiveAccumulatorInvoker.class);
        parameterClasses.addAll(IntStream.range(0, numInputs).mapToObj(i -> BlockInputDecoder.class).collect(Collectors.toList()));
        parameterClasses.add(HiveAccumulatorState.class);
        parameterClasses.addAll(IntStream.range(0, numInputs).mapToObj(i -> Block.class).collect(Collectors.toList()));
        parameterClasses.add(Integer.TYPE);
        return MethodHandleUtil.methodHandle(generatedClass, (String)INPUT_FUNCTION_METHOD, (Class[])parameterClasses.toArray(new Class[0]));
    }

    public static void combine(HiveAccumulatorInvoker invoker, HiveAccumulatorState state, HiveAccumulatorState otherState) {
        invoker.combine(state, otherState);
    }

    public static void output(HiveAccumulatorInvoker invoker, HiveAccumulatorState state, BlockBuilder out) {
        invoker.output(state, out);
    }
}

