/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.functions.aggregation;

import com.facebook.presto.hive.functions.aggregation.HiveAccumulatorState;
import java.util.function.Supplier;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.openjdk.jol.info.ClassLayout;

public final class SingleHiveAccumulatorState
implements HiveAccumulatorState {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(SingleHiveAccumulatorState.class).instanceSize();
    private transient GenericUDAFEvaluator.AggregationBuffer buffer;
    private transient GenericUDAFEvaluator.AggregationBuffer prevBuffer;
    private transient long prevBufferSize;

    public SingleHiveAccumulatorState(Supplier<GenericUDAFEvaluator.AggregationBuffer> bufferSupplier) {
        this.buffer = bufferSupplier.get();
    }

    @Override
    public GenericUDAFEvaluator.AggregationBuffer getAggregationBuffer() {
        return this.buffer;
    }

    @Override
    public void setAggregationBuffer(GenericUDAFEvaluator.AggregationBuffer buffer) {
        this.buffer = buffer;
    }

    public long getEstimatedSize() {
        if (this.buffer == null) {
            return INSTANCE_SIZE;
        }
        if (this.buffer != this.prevBuffer) {
            this.prevBufferSize = ClassLayout.parseClass(this.buffer.getClass()).instanceSize();
            this.prevBuffer = this.buffer;
        }
        return INSTANCE_SIZE + this.prevBufferSize;
    }
}

