/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchdomain.model.SuggestRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SuggestRequestMarshaller
implements Marshaller<Request<SuggestRequest>, SuggestRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<SuggestRequest> marshall(SuggestRequest suggestRequest) {
        String value;
        String name;
        if (suggestRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SuggestRequest> request = new DefaultRequest<SuggestRequest>(suggestRequest, "AmazonCloudSearchDomain");
        String target = "AmazonCloudSearch2013.Suggest";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Query")) {
            name = DYNAMIC_QUERY_PARAMS.get("Query");
            String string = value = suggestRequest.getQuery() == null ? null : StringUtils.fromString(suggestRequest.getQuery());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Query}", suggestRequest.getQuery() == null ? "" : StringUtils.fromString(suggestRequest.getQuery()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Suggester")) {
            name = DYNAMIC_QUERY_PARAMS.get("Suggester");
            String string = value = suggestRequest.getSuggester() == null ? null : StringUtils.fromString(suggestRequest.getSuggester());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Suggester}", suggestRequest.getSuggester() == null ? "" : StringUtils.fromString(suggestRequest.getSuggester()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("Size")) {
            name = DYNAMIC_QUERY_PARAMS.get("Size");
            String string = value = suggestRequest.getSize() == null ? null : StringUtils.fromLong(suggestRequest.getSize());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Size}", suggestRequest.getSize() == null ? "" : StringUtils.fromLong(suggestRequest.getSize()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        return request;
    }

    static {
        String path = "/2013-01-01/suggest?format=sdk&pretty=true&q={Query}&suggester={Suggester}&size={Size}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

