/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class UnassignPrivateIpAddressesRequestMarshaller
implements Marshaller<Request<UnassignPrivateIpAddressesRequest>, UnassignPrivateIpAddressesRequest> {
    @Override
    public Request<UnassignPrivateIpAddressesRequest> marshall(UnassignPrivateIpAddressesRequest unassignPrivateIpAddressesRequest) {
        if (unassignPrivateIpAddressesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UnassignPrivateIpAddressesRequest> request = new DefaultRequest<UnassignPrivateIpAddressesRequest>(unassignPrivateIpAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "UnassignPrivateIpAddresses");
        request.addParameter("Version", "2014-06-15");
        if (unassignPrivateIpAddressesRequest.getNetworkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString(unassignPrivateIpAddressesRequest.getNetworkInterfaceId()));
        }
        List<String> privateIpAddressesList = unassignPrivateIpAddressesRequest.getPrivateIpAddresses();
        int privateIpAddressesListIndex = 1;
        for (String privateIpAddressesListValue : privateIpAddressesList) {
            if (privateIpAddressesListValue != null) {
                request.addParameter("PrivateIpAddress." + privateIpAddressesListIndex, StringUtils.fromString(privateIpAddressesListValue));
            }
            ++privateIpAddressesListIndex;
        }
        return request;
    }
}

