/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.logs.model.MetricTransformation;
import com.amazonaws.services.logs.model.PutMetricFilterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class PutMetricFilterRequestMarshaller
implements Marshaller<Request<PutMetricFilterRequest>, PutMetricFilterRequest> {
    @Override
    public Request<PutMetricFilterRequest> marshall(PutMetricFilterRequest putMetricFilterRequest) {
        if (putMetricFilterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutMetricFilterRequest> request = new DefaultRequest<PutMetricFilterRequest>(putMetricFilterRequest, "AWSLogs");
        String target = "Logs_20140328.PutMetricFilter";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag metricTransformationsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (putMetricFilterRequest.getLogGroupName() != null) {
                jsonWriter.key("logGroupName").value(putMetricFilterRequest.getLogGroupName());
            }
            if (putMetricFilterRequest.getFilterName() != null) {
                jsonWriter.key("filterName").value(putMetricFilterRequest.getFilterName());
            }
            if (putMetricFilterRequest.getFilterPattern() != null) {
                jsonWriter.key("filterPattern").value(putMetricFilterRequest.getFilterPattern());
            }
            if (!((metricTransformationsList = (ListWithAutoConstructFlag)putMetricFilterRequest.getMetricTransformations()) == null || metricTransformationsList.isAutoConstruct() && metricTransformationsList.isEmpty())) {
                jsonWriter.key("metricTransformations");
                jsonWriter.array();
                for (MetricTransformation metricTransformationsListValue : metricTransformationsList) {
                    if (metricTransformationsListValue == null) continue;
                    jsonWriter.object();
                    if (metricTransformationsListValue.getMetricName() != null) {
                        jsonWriter.key("metricName").value(metricTransformationsListValue.getMetricName());
                    }
                    if (metricTransformationsListValue.getMetricNamespace() != null) {
                        jsonWriter.key("metricNamespace").value(metricTransformationsListValue.getMetricNamespace());
                    }
                    if (metricTransformationsListValue.getMetricValue() != null) {
                        jsonWriter.key("metricValue").value(metricTransformationsListValue.getMetricValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

