/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread;

import com.facebook.presto.hadoop.shaded.org.jets3t.service.io.BytesProgressWatcher;
import com.facebook.presto.hadoop.shaded.org.jets3t.service.multithread.CancelEventTrigger;

public class ThreadWatcher {
    private long completedThreads = 0L;
    private long threadCount = 0L;
    private CancelEventTrigger cancelEventListener = null;
    private BytesProgressWatcher[] progressWatchers = null;

    protected ThreadWatcher(BytesProgressWatcher[] progressWatchers) {
        this.progressWatchers = progressWatchers;
        this.threadCount = this.progressWatchers.length;
    }

    protected ThreadWatcher(long threadCount) {
        this.threadCount = threadCount;
    }

    protected void updateThreadsCompletedCount(long completedThreads) {
        this.updateThreadsCompletedCount(completedThreads, null);
    }

    protected void updateThreadsCompletedCount(long completedThreads, CancelEventTrigger cancelEventListener) {
        this.completedThreads = completedThreads;
        this.cancelEventListener = cancelEventListener;
    }

    public long getCompletedThreads() {
        return this.completedThreads;
    }

    public long getThreadCount() {
        return this.threadCount;
    }

    public boolean isBytesTransferredInfoAvailable() {
        return this.progressWatchers != null;
    }

    public long getBytesTotal() throws IllegalStateException {
        if (!this.isBytesTransferredInfoAvailable()) {
            throw new IllegalStateException("Bytes Transferred Info is not available in this object");
        }
        return BytesProgressWatcher.sumBytesToTransfer(this.progressWatchers);
    }

    public long getBytesTransferred() {
        if (!this.isBytesTransferredInfoAvailable()) {
            throw new IllegalStateException("Bytes Transferred Info is not available in this object");
        }
        return BytesProgressWatcher.sumBytesTransferred(this.progressWatchers);
    }

    public long getBytesPerSecond() {
        return BytesProgressWatcher.calculateRecentByteRatePerSecond(this.progressWatchers);
    }

    public boolean isTimeRemainingAvailable() {
        return this.progressWatchers != null;
    }

    public long getTimeRemaining() {
        if (!this.isTimeRemainingAvailable()) {
            throw new IllegalStateException("Time remaining estimate is not available in this object");
        }
        return BytesProgressWatcher.calculateRemainingTime(this.progressWatchers);
    }

    public boolean isCancelTaskSupported() {
        return this.cancelEventListener != null;
    }

    public void cancelTask() {
        if (this.isCancelTaskSupported()) {
            this.cancelEventListener.cancelTask(this);
        }
    }

    public CancelEventTrigger getCancelEventListener() {
        return this.cancelEventListener;
    }
}

