/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3native;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.s3.S3Exception;
import org.apache.hadoop.fs.s3native.FileMetadata;
import org.apache.hadoop.fs.s3native.Jets3tNativeFileSystemStore;
import org.apache.hadoop.fs.s3native.NativeFileSystemStore;
import org.apache.hadoop.fs.s3native.PartialListing;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class NativeS3FileSystem
extends FileSystem {
    public static final Log LOG = LogFactory.getLog(NativeS3FileSystem.class);
    private static final String FOLDER_SUFFIX = "_$folder$";
    static final String PATH_DELIMITER = "/";
    private static final int S3_MAX_LISTING_LENGTH = 1000;
    private URI uri;
    private NativeFileSystemStore store;
    private Path workingDir;

    public NativeS3FileSystem() {
    }

    public NativeS3FileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    @Override
    public String getScheme() {
        return "s3n";
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        if (this.store == null) {
            this.store = NativeS3FileSystem.createDefaultStore(conf);
        }
        this.store.initialize(uri, conf);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this);
    }

    private static NativeFileSystemStore createDefaultStore(Configuration conf) {
        Jets3tNativeFileSystemStore store = new Jets3tNativeFileSystemStore();
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(conf.getInt("fs.s3.maxRetries", 4), conf.getLong("fs.s3.sleepTimeSeconds", 10L), TimeUnit.SECONDS);
        HashMap<Class<? extends Exception>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<? extends Exception>, RetryPolicy>();
        exceptionToPolicyMap.put(IOException.class, basePolicy);
        exceptionToPolicyMap.put(S3Exception.class, basePolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException(RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap<String, RetryPolicy> methodNameToPolicyMap = new HashMap<String, RetryPolicy>();
        methodNameToPolicyMap.put("storeFile", methodPolicy);
        methodNameToPolicyMap.put("rename", methodPolicy);
        return (NativeFileSystemStore)RetryProxy.create(NativeFileSystemStore.class, store, methodNameToPolicyMap);
    }

    private static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String ret = path.toUri().getPath().substring(1);
        if (ret.endsWith(PATH_DELIMITER) && ret.indexOf(PATH_DELIMITER) != ret.length() - 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private static Path keyToPath(String key) {
        return new Path(PATH_DELIMITER + key);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new IOException("File already exists:" + f);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new file '" + f + "' in S3");
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        return new FSDataOutputStream(new NativeS3FsOutputStream(this.getConf(), this.store, key, progress, bufferSize), this.statistics);
    }

    @Override
    public boolean delete(Path f, boolean recurse) throws IOException {
        FileStatus status;
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Delete called for '" + f + "' but file does not exist, so returning false");
            }
            return false;
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        if (status.isDirectory()) {
            PartialListing listing;
            if (!recurse && this.listStatus(f).length > 0) {
                throw new IOException("Can not delete " + f + " at is a not empty directory and recurse option is false");
            }
            this.createParent(f);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting directory '" + f + "'");
            }
            String priorLastKey = null;
            do {
                listing = this.store.list(key, 1000, priorLastKey, true);
                for (FileMetadata file : listing.getFiles()) {
                    this.store.delete(file.getKey());
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            try {
                this.store.delete(key + FOLDER_SUFFIX);
            }
            catch (FileNotFoundException e) {}
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deleting file '" + f + "'");
            }
            this.createParent(f);
            this.store.delete(key);
        }
        return true;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        if (key.length() == 0) {
            return this.newDirectory(absolutePath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus retrieving metadata for key '" + key + "'");
        }
        if ((meta = this.store.retrieveMetadata(key)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'file' for key '" + key + "'");
            }
            return this.newFile(meta, absolutePath);
        }
        if (this.store.retrieveMetadata(key + FOLDER_SUFFIX) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'directory' for key '" + key + "' as '" + key + FOLDER_SUFFIX + "' exists");
            }
            return this.newDirectory(absolutePath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus listing key '" + key + "'");
        }
        if ((listing = this.store.list(key, 1)).getFiles().length > 0 || listing.getCommonPrefixes().length > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getFileStatus returning 'directory' for key '" + key + "' as it has contents");
            }
            return this.newDirectory(absolutePath);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFileStatus could not find key '" + key + "'");
        }
        throw new FileNotFoundException("No such file or directory '" + absolutePath + "'");
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        PartialListing listing;
        FileMetadata meta;
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        if (key.length() > 0 && (meta = this.store.retrieveMetadata(key)) != null) {
            return new FileStatus[]{this.newFile(meta, absolutePath)};
        }
        URI pathUri = absolutePath.toUri();
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        String priorLastKey = null;
        do {
            String relativePath;
            Path subpath;
            listing = this.store.list(key, 1000, priorLastKey, false);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                subpath = NativeS3FileSystem.keyToPath(fileMetadata.getKey());
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                if (fileMetadata.getKey().equals(key + PATH_DELIMITER)) continue;
                if (relativePath.endsWith(FOLDER_SUFFIX)) {
                    status.add(this.newDirectory(new Path(absolutePath, relativePath.substring(0, relativePath.indexOf(FOLDER_SUFFIX)))));
                    continue;
                }
                status.add(this.newFile(fileMetadata, subpath));
            }
            for (String commonPrefix : listing.getCommonPrefixes()) {
                subpath = NativeS3FileSystem.keyToPath(commonPrefix);
                relativePath = pathUri.relativize(subpath.toUri()).getPath();
                status.add(this.newDirectory(new Path(absolutePath, relativePath)));
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
        if (status.isEmpty() && key.length() > 0 && this.store.retrieveMetadata(key + FOLDER_SUFFIX) == null) {
            throw new FileNotFoundException("File " + f + " does not exist.");
        }
        return status.toArray(new FileStatus[status.size()]);
    }

    private FileStatus newFile(FileMetadata meta, Path path) {
        return new FileStatus(meta.getLength(), false, 1, this.getDefaultBlockSize(), meta.getLastModified(), path.makeQualified(this));
    }

    private FileStatus newDirectory(Path path) {
        return new FileStatus(0L, true, 1, 0L, 0L, path.makeQualified(this));
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        Path absolutePath = this.makeAbsolute(f);
        ArrayList<Path> paths = new ArrayList<Path>();
        do {
            paths.add(0, absolutePath);
        } while ((absolutePath = absolutePath.getParent()) != null);
        boolean result = true;
        for (Path path : paths) {
            result &= this.mkdir(path);
        }
        return result;
    }

    private boolean mkdir(Path f) throws IOException {
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isFile()) {
                throw new IOException(String.format("Can't make directory for path '%s' since it is a file.", f));
            }
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Making dir '" + f + "' in S3");
            }
            String key = NativeS3FileSystem.pathToKey(f) + FOLDER_SUFFIX;
            this.store.storeEmptyFile(key);
        }
        return true;
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FileStatus fs = this.getFileStatus(f);
        if (fs.isDirectory()) {
            throw new IOException("'" + f + "' is a directory");
        }
        LOG.info("Opening '" + f + "' for reading");
        Path absolutePath = this.makeAbsolute(f);
        String key = NativeS3FileSystem.pathToKey(absolutePath);
        return new FSDataInputStream(new BufferedFSInputStream(new NativeS3FsInputStream(this.store, this.statistics, this.store.retrieve(key), key), bufferSize));
    }

    private void createParent(Path path) throws IOException {
        String key;
        Path parent = path.getParent();
        if (parent != null && (key = NativeS3FileSystem.pathToKey(this.makeAbsolute(parent))).length() > 0) {
            this.store.storeEmptyFile(key + FOLDER_SUFFIX);
        }
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        boolean srcIsFile;
        String dstKey;
        String srcKey = NativeS3FileSystem.pathToKey(this.makeAbsolute(src));
        if (srcKey.length() == 0) {
            return false;
        }
        String debugPreamble = "Renaming '" + src + "' to '" + dst + "' - ";
        try {
            boolean dstIsFile = this.getFileStatus(dst).isFile();
            if (dstIsFile) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(debugPreamble + "returning false as dst is an already existing file");
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "using dst as output directory");
            }
            dstKey = NativeS3FileSystem.pathToKey(this.makeAbsolute(new Path(dst, src.getName())));
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "using dst as output destination");
            }
            dstKey = NativeS3FileSystem.pathToKey(this.makeAbsolute(dst));
            try {
                if (this.getFileStatus(dst.getParent()).isFile()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(debugPreamble + "returning false as dst parent exists and is a file");
                    }
                    return false;
                }
            }
            catch (FileNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(debugPreamble + "returning false as dst parent does not exist");
                }
                return false;
            }
        }
        try {
            srcIsFile = this.getFileStatus(src).isFile();
        }
        catch (FileNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "returning false as src does not exist");
            }
            return false;
        }
        if (srcIsFile) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "src is file, so doing copy then delete in S3");
            }
            this.store.copy(srcKey, dstKey);
            this.store.delete(srcKey);
        } else {
            PartialListing listing;
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "src is directory, so copying contents");
            }
            this.store.storeEmptyFile(dstKey + FOLDER_SUFFIX);
            ArrayList<String> keysToDelete = new ArrayList<String>();
            String priorLastKey = null;
            do {
                listing = this.store.list(srcKey, 1000, priorLastKey, true);
                for (FileMetadata file : listing.getFiles()) {
                    keysToDelete.add(file.getKey());
                    this.store.copy(file.getKey(), dstKey + file.getKey().substring(srcKey.length()));
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "all files in src copied, now removing src files");
            }
            for (String key : keysToDelete) {
                this.store.delete(key);
            }
            try {
                this.store.delete(srcKey + FOLDER_SUFFIX);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(debugPreamble + "done");
            }
        }
        return true;
    }

    @Override
    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.s3n.block.size", 0x4000000L);
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    private class NativeS3FsOutputStream
    extends OutputStream {
        private Configuration conf;
        private String key;
        private File backupFile;
        private OutputStream backupStream;
        private MessageDigest digest;
        private boolean closed;

        public NativeS3FsOutputStream(Configuration conf, NativeFileSystemStore store, String key, Progressable progress, int bufferSize) throws IOException {
            this.conf = conf;
            this.key = key;
            this.backupFile = this.newBackupFile();
            LOG.info("OutputStream for key '" + key + "' writing to tempfile '" + this.backupFile + "'");
            try {
                this.digest = MessageDigest.getInstance("MD5");
                this.backupStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.backupFile), this.digest));
            }
            catch (NoSuchAlgorithmException e) {
                LOG.warn("Cannot load MD5 digest algorithm,skipping message integrity check.", e);
                this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFile));
            }
        }

        private File newBackupFile() throws IOException {
            File dir = new File(this.conf.get("fs.s3.buffer.dir"));
            if (!dir.mkdirs() && !dir.exists()) {
                throw new IOException("Cannot create S3 buffer directory: " + dir);
            }
            File result = File.createTempFile("output-", ".tmp", dir);
            result.deleteOnExit();
            return result;
        }

        @Override
        public void flush() throws IOException {
            this.backupStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.backupStream.close();
            LOG.info("OutputStream for key '" + this.key + "' closed. Now beginning upload");
            try {
                byte[] md5Hash = this.digest == null ? null : this.digest.digest();
                NativeS3FileSystem.this.store.storeFile(this.key, this.backupFile, md5Hash);
            }
            finally {
                if (!this.backupFile.delete()) {
                    LOG.warn("Could not delete temporary s3n file: " + this.backupFile);
                }
                super.close();
                this.closed = true;
            }
            LOG.info("OutputStream for key '" + this.key + "' upload complete");
        }

        @Override
        public void write(int b) throws IOException {
            this.backupStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.backupStream.write(b, off, len);
        }
    }

    static class NativeS3FsInputStream
    extends FSInputStream {
        private NativeFileSystemStore store;
        private FileSystem.Statistics statistics;
        private InputStream in;
        private final String key;
        private long pos = 0L;

        public NativeS3FsInputStream(NativeFileSystemStore store, FileSystem.Statistics statistics, InputStream in, String key) {
            this.store = store;
            this.statistics = statistics;
            this.in = in;
            this.key = key;
        }

        @Override
        public synchronized int read() throws IOException {
            int result = -1;
            try {
                result = this.in.read();
            }
            catch (IOException e) {
                LOG.info("Received IOException while reading '" + this.key + "', attempting to reopen.");
                this.seek(this.pos);
                result = this.in.read();
            }
            if (result != -1) {
                ++this.pos;
            }
            if (this.statistics != null && result != -1) {
                this.statistics.incrementBytesRead(1L);
            }
            return result;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int result = -1;
            try {
                result = this.in.read(b, off, len);
            }
            catch (IOException e) {
                LOG.info("Received IOException while reading '" + this.key + "', attempting to reopen.");
                this.seek(this.pos);
                result = this.in.read(b, off, len);
            }
            if (result > 0) {
                this.pos += (long)result;
            }
            if (this.statistics != null && result > 0) {
                this.statistics.incrementBytesRead(result);
            }
            return result;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public synchronized void seek(long pos) throws IOException {
            this.in.close();
            LOG.info("Opening key '" + this.key + "' for reading at position '" + pos + "'");
            this.in = this.store.retrieve(this.key, pos);
            this.pos = pos;
        }

        @Override
        public synchronized long getPos() throws IOException {
            return this.pos;
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }
    }
}

