/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import com.facebook.presto.hadoop.shaded.com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;

abstract class AbstractINodeDiff<N extends INode, A extends INodeAttributes, D extends AbstractINodeDiff<N, A, D>>
implements Comparable<Integer> {
    Snapshot snapshot;
    A snapshotINode;
    private D posteriorDiff;

    AbstractINodeDiff(Snapshot snapshot, A snapshotINode, D posteriorDiff) {
        Preconditions.checkNotNull(snapshot, "snapshot is null");
        this.snapshot = snapshot;
        this.snapshotINode = snapshotINode;
        this.posteriorDiff = posteriorDiff;
    }

    @Override
    public final int compareTo(Integer that) {
        return Snapshot.ID_INTEGER_COMPARATOR.compare(this.snapshot.getId(), that);
    }

    public final Snapshot getSnapshot() {
        return this.snapshot;
    }

    final void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    final D getPosterior() {
        return this.posteriorDiff;
    }

    final void setPosterior(D posterior) {
        this.posteriorDiff = posterior;
    }

    void saveSnapshotCopy(A snapshotCopy, N currentINode) {
        Preconditions.checkState(this.snapshotINode == null, "Expected snapshotINode to be null");
        this.snapshotINode = snapshotCopy;
    }

    A getSnapshotINode() {
        AbstractINodeDiff<N, A, D> d = this;
        while (d.snapshotINode == null) {
            if (d.posteriorDiff == null) {
                return null;
            }
            d = d.posteriorDiff;
        }
        return d.snapshotINode;
    }

    abstract Quota.Counts combinePosteriorAndCollectBlocks(N var1, D var2, INode.BlocksMapUpdateInfo var3, List<INode> var4);

    abstract Quota.Counts destroyDiffAndCollectBlocks(N var1, INode.BlocksMapUpdateInfo var2, List<INode> var3);

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.snapshot + " (post=" + (this.posteriorDiff == null ? null : ((AbstractINodeDiff)this.posteriorDiff).snapshot) + ")";
    }

    void writeSnapshot(DataOutput out) throws IOException {
        out.writeInt(this.snapshot.getId());
    }

    abstract void write(DataOutput var1, SnapshotFSImageFormat.ReferenceMap var2) throws IOException;
}

