/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import com.facebook.presto.hadoop.shaded.com.google.common.cache.CacheBuilder;
import com.facebook.presto.hadoop.shaded.com.google.common.cache.CacheLoader;
import com.facebook.presto.hadoop.shaded.com.google.common.cache.LoadingCache;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CodecPool {
    private static final Log LOG = LogFactory.getLog(CodecPool.class);
    private static final Map<Class<Compressor>, List<Compressor>> compressorPool = new HashMap<Class<Compressor>, List<Compressor>>();
    private static final Map<Class<Decompressor>, List<Decompressor>> decompressorPool = new HashMap<Class<Decompressor>, List<Decompressor>>();
    private static final LoadingCache<Class<Compressor>, AtomicInteger> compressorCounts = CodecPool.createCache(Compressor.class);
    private static final LoadingCache<Class<Decompressor>, AtomicInteger> decompressorCounts = CodecPool.createCache(Decompressor.class);

    private static <T> LoadingCache<Class<T>, AtomicInteger> createCache(Class<T> klass) {
        return CacheBuilder.newBuilder().build(new CacheLoader<Class<T>, AtomicInteger>(){

            @Override
            public AtomicInteger load(Class<T> key) throws Exception {
                return new AtomicInteger();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T borrow(Map<Class<T>, List<T>> pool, Class<? extends T> codecClass) {
        T codec = null;
        Map<Class<T>, List<T>> map = pool;
        synchronized (map) {
            List<T> codecList;
            if (pool.containsKey(codecClass) && (codecList = pool.get(codecClass)) != null) {
                List<T> list = codecList;
                synchronized (list) {
                    if (!codecList.isEmpty()) {
                        codec = codecList.remove(codecList.size() - 1);
                    }
                }
            }
        }
        return codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void payback(Map<Class<T>, List<T>> pool, T codec) {
        if (codec != null) {
            Class<T> codecClass = ReflectionUtils.getClass(codec);
            Map<Class<T>, List<T>> map = pool;
            synchronized (map) {
                List<T> codecList;
                if (!pool.containsKey(codecClass)) {
                    pool.put(codecClass, new ArrayList());
                }
                List<T> list = codecList = pool.get(codecClass);
                synchronized (list) {
                    codecList.add(codec);
                }
            }
        }
    }

    private static <T> int getLeaseCount(LoadingCache<Class<T>, AtomicInteger> usageCounts, Class<? extends T> codecClass) {
        return usageCounts.getUnchecked(codecClass).get();
    }

    private static <T> void updateLeaseCount(LoadingCache<Class<T>, AtomicInteger> usageCounts, T codec, int delta) {
        if (codec != null) {
            Class<T> codecClass = ReflectionUtils.getClass(codec);
            usageCounts.getUnchecked(codecClass).addAndGet(delta);
        }
    }

    public static Compressor getCompressor(CompressionCodec codec, Configuration conf) {
        Compressor compressor = CodecPool.borrow(compressorPool, codec.getCompressorType());
        if (compressor == null) {
            compressor = codec.createCompressor();
            LOG.info("Got brand-new compressor [" + codec.getDefaultExtension() + "]");
        } else {
            compressor.reinit(conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got recycled compressor");
            }
        }
        CodecPool.updateLeaseCount(compressorCounts, compressor, 1);
        return compressor;
    }

    public static Compressor getCompressor(CompressionCodec codec) {
        return CodecPool.getCompressor(codec, null);
    }

    public static Decompressor getDecompressor(CompressionCodec codec) {
        Decompressor decompressor = CodecPool.borrow(decompressorPool, codec.getDecompressorType());
        if (decompressor == null) {
            decompressor = codec.createDecompressor();
            LOG.info("Got brand-new decompressor [" + codec.getDefaultExtension() + "]");
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Got recycled decompressor");
        }
        CodecPool.updateLeaseCount(decompressorCounts, decompressor, 1);
        return decompressor;
    }

    public static void returnCompressor(Compressor compressor) {
        if (compressor == null) {
            return;
        }
        if (compressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            return;
        }
        compressor.reset();
        CodecPool.payback(compressorPool, compressor);
        CodecPool.updateLeaseCount(compressorCounts, compressor, -1);
    }

    public static void returnDecompressor(Decompressor decompressor) {
        if (decompressor == null) {
            return;
        }
        if (decompressor.getClass().isAnnotationPresent(DoNotPool.class)) {
            return;
        }
        decompressor.reset();
        CodecPool.payback(decompressorPool, decompressor);
        CodecPool.updateLeaseCount(decompressorCounts, decompressor, -1);
    }

    public static int getLeasedCompressorsCount(CompressionCodec codec) {
        return codec == null ? 0 : CodecPool.getLeaseCount(compressorCounts, codec.getCompressorType());
    }

    public static int getLeasedDecompressorsCount(CompressionCodec codec) {
        return codec == null ? 0 : CodecPool.getLeaseCount(decompressorCounts, codec.getDecompressorType());
    }
}

