/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapreduce.JobStatus;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FileOutputCommitter
extends OutputCommitter {
    public static final Log LOG = LogFactory.getLog("org.apache.hadoop.mapred.FileOutputCommitter");
    public static final String TEMP_DIR_NAME = "_temporary";
    public static final String SUCCEEDED_FILE_NAME = "_SUCCESS";
    static final String SUCCESSFUL_JOB_OUTPUT_DIR_MARKER = "mapreduce.fileoutputcommitter.marksuccessfuljobs";
    private org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter wrapped = null;

    private static Path getOutputPath(JobContext context) {
        JobConf conf = context.getJobConf();
        return FileOutputFormat.getOutputPath(conf);
    }

    private static Path getOutputPath(TaskAttemptContext context) {
        JobConf conf = context.getJobConf();
        return FileOutputFormat.getOutputPath(conf);
    }

    private org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter getWrapped(JobContext context) throws IOException {
        if (this.wrapped == null) {
            this.wrapped = new org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter(FileOutputCommitter.getOutputPath(context), context);
        }
        return this.wrapped;
    }

    private org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter getWrapped(TaskAttemptContext context) throws IOException {
        if (this.wrapped == null) {
            this.wrapped = new org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter(FileOutputCommitter.getOutputPath(context), context);
        }
        return this.wrapped;
    }

    @InterfaceAudience.Private
    Path getJobAttemptPath(JobContext context) {
        Path out = FileOutputCommitter.getOutputPath(context);
        return out == null ? null : org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.getJobAttemptPath(context, out);
    }

    @InterfaceAudience.Private
    public Path getTaskAttemptPath(TaskAttemptContext context) throws IOException {
        Path out = FileOutputCommitter.getOutputPath(context);
        return out == null ? null : this.getTaskAttemptPath(context, out);
    }

    private Path getTaskAttemptPath(TaskAttemptContext context, Path out) throws IOException {
        Path workPath = FileOutputFormat.getWorkOutputPath(context.getJobConf());
        if (workPath == null && out != null) {
            return org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.getTaskAttemptPath(context, out);
        }
        return workPath;
    }

    @InterfaceAudience.Private
    Path getCommittedTaskPath(TaskAttemptContext context) {
        Path out = FileOutputCommitter.getOutputPath(context);
        return out == null ? null : org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter.getCommittedTaskPath(context, out);
    }

    public Path getWorkPath(TaskAttemptContext context, Path outputPath) throws IOException {
        return outputPath == null ? null : this.getTaskAttemptPath(context, outputPath);
    }

    @Override
    public void setupJob(JobContext context) throws IOException {
        this.getWrapped(context).setupJob(context);
    }

    @Override
    public void commitJob(JobContext context) throws IOException {
        this.getWrapped(context).commitJob(context);
    }

    @Override
    @Deprecated
    public void cleanupJob(JobContext context) throws IOException {
        this.getWrapped(context).cleanupJob(context);
    }

    @Override
    public void abortJob(JobContext context, int runState) throws IOException {
        JobStatus.State state;
        if (runState == JobStatus.State.RUNNING.getValue()) {
            state = JobStatus.State.RUNNING;
        } else if (runState == JobStatus.State.SUCCEEDED.getValue()) {
            state = JobStatus.State.SUCCEEDED;
        } else if (runState == JobStatus.State.FAILED.getValue()) {
            state = JobStatus.State.FAILED;
        } else if (runState == JobStatus.State.PREP.getValue()) {
            state = JobStatus.State.PREP;
        } else if (runState == JobStatus.State.KILLED.getValue()) {
            state = JobStatus.State.KILLED;
        } else {
            throw new IllegalArgumentException(runState + " is not a valid runState.");
        }
        this.getWrapped(context).abortJob(context, state);
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
        this.getWrapped(context).setupTask(context);
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        this.getWrapped(context).commitTask(context, this.getTaskAttemptPath(context));
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        this.getWrapped(context).abortTask(context, this.getTaskAttemptPath(context));
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        return this.getWrapped(context).needsTaskCommit(context, this.getTaskAttemptPath(context));
    }

    @Override
    public boolean isRecoverySupported() {
        return true;
    }

    @Override
    public void recoverTask(TaskAttemptContext context) throws IOException {
        this.getWrapped(context).recoverTask(context);
    }
}

