/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.BasicParser;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.CommandLine;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.Option;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.OptionBuilder;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.Options;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.ParseException;
import com.facebook.presto.hadoop.shaded.org.apache.commons.cli.Parser;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.mapred.lib.LazyOutputFormat;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.mapred.pipes.PipesMapRunner;
import org.apache.hadoop.mapred.pipes.PipesNonJavaInputFormat;
import org.apache.hadoop.mapred.pipes.PipesPartitioner;
import org.apache.hadoop.mapred.pipes.PipesReducer;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Submitter
extends Configured
implements Tool {
    protected static final Log LOG = LogFactory.getLog(Submitter.class);
    public static final String PRESERVE_COMMANDFILE = "mapreduce.pipes.commandfile.preserve";
    public static final String EXECUTABLE = "mapreduce.pipes.executable";
    public static final String INTERPRETOR = "mapreduce.pipes.executable.interpretor";
    public static final String IS_JAVA_MAP = "mapreduce.pipes.isjavamapper";
    public static final String IS_JAVA_RR = "mapreduce.pipes.isjavarecordreader";
    public static final String IS_JAVA_RW = "mapreduce.pipes.isjavarecordwriter";
    public static final String IS_JAVA_REDUCE = "mapreduce.pipes.isjavareducer";
    public static final String PARTITIONER = "mapreduce.pipes.partitioner";
    public static final String INPUT_FORMAT = "mapreduce.pipes.inputformat";
    public static final String PORT = "mapreduce.pipes.command.port";

    public Submitter() {
        this(new Configuration());
    }

    public Submitter(Configuration conf) {
        this.setConf(conf);
    }

    public static String getExecutable(JobConf conf) {
        return conf.get(EXECUTABLE);
    }

    public static void setExecutable(JobConf conf, String executable) {
        conf.set(EXECUTABLE, executable);
    }

    public static void setIsJavaRecordReader(JobConf conf, boolean value) {
        conf.setBoolean(IS_JAVA_RR, value);
    }

    public static boolean getIsJavaRecordReader(JobConf conf) {
        return conf.getBoolean(IS_JAVA_RR, false);
    }

    public static void setIsJavaMapper(JobConf conf, boolean value) {
        conf.setBoolean(IS_JAVA_MAP, value);
    }

    public static boolean getIsJavaMapper(JobConf conf) {
        return conf.getBoolean(IS_JAVA_MAP, false);
    }

    public static void setIsJavaReducer(JobConf conf, boolean value) {
        conf.setBoolean(IS_JAVA_REDUCE, value);
    }

    public static boolean getIsJavaReducer(JobConf conf) {
        return conf.getBoolean(IS_JAVA_REDUCE, false);
    }

    public static void setIsJavaRecordWriter(JobConf conf, boolean value) {
        conf.setBoolean(IS_JAVA_RW, value);
    }

    public static boolean getIsJavaRecordWriter(JobConf conf) {
        return conf.getBoolean(IS_JAVA_RW, false);
    }

    private static void setIfUnset(JobConf conf, String key, String value) {
        if (conf.get(key) == null) {
            conf.set(key, value);
        }
    }

    static void setJavaPartitioner(JobConf conf, Class cls) {
        conf.set(PARTITIONER, cls.getName());
    }

    static Class<? extends Partitioner> getJavaPartitioner(JobConf conf) {
        return conf.getClass(PARTITIONER, HashPartitioner.class, Partitioner.class);
    }

    public static boolean getKeepCommandFile(JobConf conf) {
        return conf.getBoolean(PRESERVE_COMMANDFILE, false);
    }

    public static void setKeepCommandFile(JobConf conf, boolean keep) {
        conf.setBoolean(PRESERVE_COMMANDFILE, keep);
    }

    @Deprecated
    public static RunningJob submitJob(JobConf conf) throws IOException {
        return Submitter.runJob(conf);
    }

    public static RunningJob runJob(JobConf conf) throws IOException {
        Submitter.setupPipesJob(conf);
        return JobClient.runJob(conf);
    }

    public static RunningJob jobSubmit(JobConf conf) throws IOException {
        Submitter.setupPipesJob(conf);
        return new JobClient(conf).submitJob(conf);
    }

    private static void setupPipesJob(JobConf conf) throws IOException {
        URI[] fileCache;
        String exec;
        if (!Submitter.getIsJavaMapper(conf)) {
            conf.setMapRunnerClass(PipesMapRunner.class);
            Submitter.setJavaPartitioner(conf, conf.getPartitionerClass());
            conf.setPartitionerClass(PipesPartitioner.class);
        }
        if (!Submitter.getIsJavaReducer(conf)) {
            conf.setReducerClass(PipesReducer.class);
            if (!Submitter.getIsJavaRecordWriter(conf)) {
                conf.setOutputFormat(NullOutputFormat.class);
            }
        }
        String textClassname = Text.class.getName();
        Submitter.setIfUnset(conf, "mapreduce.map.output.key.class", textClassname);
        Submitter.setIfUnset(conf, "mapreduce.map.output.value.class", textClassname);
        Submitter.setIfUnset(conf, "mapreduce.job.output.key.class", textClassname);
        Submitter.setIfUnset(conf, "mapreduce.job.output.value.class", textClassname);
        if (!Submitter.getIsJavaRecordReader(conf) && !Submitter.getIsJavaMapper(conf)) {
            conf.setClass(INPUT_FORMAT, conf.getInputFormat().getClass(), InputFormat.class);
            conf.setInputFormat(PipesNonJavaInputFormat.class);
        }
        if ((exec = Submitter.getExecutable(conf)) == null) {
            throw new IllegalArgumentException("No application program defined.");
        }
        if (exec.contains("#")) {
            String defScript = "$HADOOP_PREFIX/src/c++/pipes/debug/pipes-default-script";
            Submitter.setIfUnset(conf, "mapreduce.map.debug.script", defScript);
            Submitter.setIfUnset(conf, "mapreduce.reduce.debug.script", defScript);
        }
        if ((fileCache = DistributedCache.getCacheFiles(conf)) == null) {
            fileCache = new URI[1];
        } else {
            URI[] tmp = new URI[fileCache.length + 1];
            System.arraycopy(fileCache, 0, tmp, 1, fileCache.length);
            fileCache = tmp;
        }
        try {
            fileCache[0] = new URI(exec);
        }
        catch (URISyntaxException e) {
            IOException ie = new IOException("Problem parsing execable URI " + exec);
            ie.initCause(e);
            throw ie;
        }
        DistributedCache.setCacheFiles(fileCache, conf);
    }

    private static <InterfaceType> Class<? extends InterfaceType> getClass(CommandLine cl, String key, JobConf conf, Class<InterfaceType> cls) throws ClassNotFoundException {
        return conf.getClassByName(cl.getOptionValue(key)).asSubclass(cls);
    }

    @Override
    public int run(String[] args) throws Exception {
        CommandLineParser cli = new CommandLineParser();
        if (args.length == 0) {
            cli.printUsage();
            return 1;
        }
        cli.addOption("input", false, "input path to the maps", "path");
        cli.addOption("output", false, "output path from the reduces", "path");
        cli.addOption("jar", false, "job jar file", "path");
        cli.addOption("inputformat", false, "java classname of InputFormat", "class");
        cli.addOption("map", false, "java classname of Mapper", "class");
        cli.addOption("partitioner", false, "java classname of Partitioner", "class");
        cli.addOption("reduce", false, "java classname of Reducer", "class");
        cli.addOption("writer", false, "java classname of OutputFormat", "class");
        cli.addOption("program", false, "URI to application executable", "class");
        cli.addOption("reduces", false, "number of reduces", "num");
        cli.addOption("jobconf", false, "\"n1=v1,n2=v2,..\" (Deprecated) Optional. Add or override a JobConf property.", "key=val");
        cli.addOption("lazyOutput", false, "Optional. Create output lazily", "boolean");
        Parser parser = cli.createParser();
        try {
            String jarFile;
            GenericOptionsParser genericParser = new GenericOptionsParser(this.getConf(), args);
            CommandLine results = parser.parse(cli.options, genericParser.getRemainingArgs());
            JobConf job = new JobConf(this.getConf());
            if (results.hasOption("input")) {
                FileInputFormat.setInputPaths(job, results.getOptionValue("input"));
            }
            if (results.hasOption("output")) {
                FileOutputFormat.setOutputPath(job, new Path(results.getOptionValue("output")));
            }
            if (results.hasOption("jar")) {
                job.setJar(results.getOptionValue("jar"));
            }
            if (results.hasOption("inputformat")) {
                Submitter.setIsJavaRecordReader(job, true);
                job.setInputFormat(Submitter.getClass(results, "inputformat", job, InputFormat.class));
            }
            if (results.hasOption("javareader")) {
                Submitter.setIsJavaRecordReader(job, true);
            }
            if (results.hasOption("map")) {
                Submitter.setIsJavaMapper(job, true);
                job.setMapperClass(Submitter.getClass(results, "map", job, Mapper.class));
            }
            if (results.hasOption("partitioner")) {
                job.setPartitionerClass(Submitter.getClass(results, "partitioner", job, Partitioner.class));
            }
            if (results.hasOption("reduce")) {
                Submitter.setIsJavaReducer(job, true);
                job.setReducerClass(Submitter.getClass(results, "reduce", job, Reducer.class));
            }
            if (results.hasOption("reduces")) {
                job.setNumReduceTasks(Integer.parseInt(results.getOptionValue("reduces")));
            }
            if (results.hasOption("writer")) {
                Submitter.setIsJavaRecordWriter(job, true);
                job.setOutputFormat(Submitter.getClass(results, "writer", job, OutputFormat.class));
            }
            if (results.hasOption("lazyOutput") && Boolean.parseBoolean(results.getOptionValue("lazyOutput"))) {
                LazyOutputFormat.setOutputFormatClass(job, job.getOutputFormat().getClass());
            }
            if (results.hasOption("program")) {
                Submitter.setExecutable(job, results.getOptionValue("program"));
            }
            if (results.hasOption("jobconf")) {
                LOG.warn("-jobconf option is deprecated, please use -D instead.");
                String options = results.getOptionValue("jobconf");
                StringTokenizer tokenizer = new StringTokenizer(options, ",");
                while (tokenizer.hasMoreTokens()) {
                    String keyVal = tokenizer.nextToken().trim();
                    String[] keyValSplit = keyVal.split("=");
                    job.set(keyValSplit[0], keyValSplit[1]);
                }
            }
            if ((jarFile = job.getJar()) != null) {
                final URL[] urls = new URL[]{FileSystem.getLocal(job).pathToFile(new Path(jarFile)).toURL()};
                ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return new URLClassLoader(urls);
                    }
                });
                job.setClassLoader(loader);
            }
            Submitter.runJob(job);
            return 0;
        }
        catch (ParseException pe) {
            LOG.info("Error : " + pe);
            cli.printUsage();
            return 1;
        }
    }

    public static void main(String[] args) throws Exception {
        int exitCode = new Submitter().run(args);
        ExitUtil.terminate(exitCode);
    }

    static class CommandLineParser {
        private Options options = new Options();

        CommandLineParser() {
        }

        void addOption(String longName, boolean required, String description, String paramName) {
            OptionBuilder.withArgName(paramName);
            OptionBuilder.hasArgs(1);
            OptionBuilder.withDescription(description);
            OptionBuilder.isRequired(required);
            Option option = OptionBuilder.create(longName);
            this.options.addOption(option);
        }

        void addArgument(String name, boolean required, String description) {
            OptionBuilder.withArgName(name);
            OptionBuilder.hasArgs(1);
            OptionBuilder.withDescription(description);
            OptionBuilder.isRequired(required);
            Option option = OptionBuilder.create();
            this.options.addOption(option);
        }

        Parser createParser() {
            BasicParser result = new BasicParser();
            return result;
        }

        void printUsage() {
            System.out.println("bin/hadoop pipes");
            System.out.println("  [-input <path>] // Input directory");
            System.out.println("  [-output <path>] // Output directory");
            System.out.println("  [-jar <jar file> // jar filename");
            System.out.println("  [-inputformat <class>] // InputFormat class");
            System.out.println("  [-map <class>] // Java Map class");
            System.out.println("  [-partitioner <class>] // Java Partitioner");
            System.out.println("  [-reduce <class>] // Java Reduce class");
            System.out.println("  [-writer <class>] // Java RecordWriter");
            System.out.println("  [-program <executable>] // executable URI");
            System.out.println("  [-reduces <num>] // number of reduces");
            System.out.println("  [-lazyOutput <true/false>] // createOutputLazily");
            System.out.println();
            GenericOptionsParser.printGenericCommandUsage(System.out);
        }
    }
}

