/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.shaded.org.apache.commons.logging.LogFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBRecordReader;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.db.MySQLDBRecordReader;
import org.apache.hadoop.mapreduce.lib.db.OracleDBRecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DBInputFormat<T extends DBWritable>
extends InputFormat<LongWritable, T>
implements Configurable {
    private static final Log LOG = LogFactory.getLog(DBInputFormat.class);
    protected String dbProductName = "DEFAULT";
    protected String conditions;
    protected Connection connection;
    protected String tableName;
    protected String[] fieldNames;
    protected DBConfiguration dbConf;

    @Override
    public void setConf(Configuration conf) {
        this.dbConf = new DBConfiguration(conf);
        try {
            this.getConnection();
            DatabaseMetaData dbMeta = this.connection.getMetaData();
            this.dbProductName = dbMeta.getDatabaseProductName().toUpperCase();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.tableName = this.dbConf.getInputTableName();
        this.fieldNames = this.dbConf.getInputFieldNames();
        this.conditions = this.dbConf.getInputConditions();
    }

    @Override
    public Configuration getConf() {
        return this.dbConf.getConf();
    }

    public DBConfiguration getDBConf() {
        return this.dbConf;
    }

    public Connection getConnection() {
        try {
            if (null == this.connection) {
                this.connection = this.dbConf.getConnection();
                this.connection.setAutoCommit(false);
                this.connection.setTransactionIsolation(8);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.connection;
    }

    public String getDBProductName() {
        return this.dbProductName;
    }

    protected RecordReader<LongWritable, T> createDBRecordReader(DBInputSplit split, Configuration conf) throws IOException {
        Class<?> inputClass = this.dbConf.getInputClass();
        try {
            if (this.dbProductName.startsWith("ORACLE")) {
                return new OracleDBRecordReader(split, inputClass, conf, this.getConnection(), this.getDBConf(), this.conditions, this.fieldNames, this.tableName);
            }
            if (this.dbProductName.startsWith("MYSQL")) {
                return new MySQLDBRecordReader(split, inputClass, conf, this.getConnection(), this.getDBConf(), this.conditions, this.fieldNames, this.tableName);
            }
            return new DBRecordReader(split, inputClass, conf, this.getConnection(), this.getDBConf(), this.conditions, this.fieldNames, this.tableName);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public RecordReader<LongWritable, T> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return this.createDBRecordReader((DBInputSplit)split, context.getConfiguration());
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        ResultSet results = null;
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            results = statement.executeQuery(this.getCountQuery());
            results.next();
            long count = results.getLong(1);
            int chunks = job.getConfiguration().getInt("mapreduce.job.maps", 1);
            long chunkSize = count / (long)chunks;
            results.close();
            statement.close();
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            for (int i = 0; i < chunks; ++i) {
                DBInputSplit split = i + 1 == chunks ? new DBInputSplit((long)i * chunkSize, count) : new DBInputSplit((long)i * chunkSize, (long)i * chunkSize + chunkSize);
                splits.add(split);
            }
            this.connection.commit();
            ArrayList<InputSplit> arrayList = splits;
            return arrayList;
        }
        catch (SQLException e) {
            throw new IOException("Got SQLException", e);
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException e1) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e1) {}
            this.closeConnection();
        }
    }

    protected String getCountQuery() {
        if (this.dbConf.getInputCountQuery() != null) {
            return this.dbConf.getInputCountQuery();
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(*) FROM " + this.tableName);
        if (this.conditions != null && this.conditions.length() > 0) {
            query.append(" WHERE " + this.conditions);
        }
        return query.toString();
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String orderBy, String ... fieldNames) {
        job.setInputFormatClass(DBInputFormat.class);
        DBConfiguration dbConf = new DBConfiguration(job.getConfiguration());
        dbConf.setInputClass(inputClass);
        dbConf.setInputTableName(tableName);
        dbConf.setInputFieldNames(fieldNames);
        dbConf.setInputConditions(conditions);
        dbConf.setInputOrderBy(orderBy);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String inputQuery, String inputCountQuery) {
        job.setInputFormatClass(DBInputFormat.class);
        DBConfiguration dbConf = new DBConfiguration(job.getConfiguration());
        dbConf.setInputClass(inputClass);
        dbConf.setInputQuery(inputQuery);
        dbConf.setInputCountQuery(inputCountQuery);
    }

    protected void closeConnection() {
        try {
            if (null != this.connection) {
                this.connection.close();
                this.connection = null;
            }
        }
        catch (SQLException sqlE) {
            LOG.debug("Exception on close", sqlE);
        }
    }

    @InterfaceStability.Evolving
    public static class DBInputSplit
    extends InputSplit
    implements Writable {
        private long end = 0L;
        private long start = 0L;

        public DBInputSplit() {
        }

        public DBInputSplit(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public String[] getLocations() throws IOException {
            return new String[0];
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }

        @Override
        public long getLength() throws IOException {
            return this.end - this.start;
        }

        @Override
        public void readFields(DataInput input) throws IOException {
            this.start = input.readLong();
            this.end = input.readLong();
        }

        @Override
        public void write(DataOutput output) throws IOException {
            output.writeLong(this.start);
            output.writeLong(this.end);
        }
    }

    @InterfaceStability.Evolving
    public static class NullDBWritable
    implements DBWritable,
    Writable {
        @Override
        public void readFields(DataInput in) throws IOException {
        }

        @Override
        public void readFields(ResultSet arg0) throws SQLException {
        }

        @Override
        public void write(DataOutput out) throws IOException {
        }

        @Override
        public void write(PreparedStatement arg0) throws SQLException {
        }
    }
}

