/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.util;

import com.facebook.presto.hive.$internal.jodd.typeconverter.Convert;
import com.facebook.presto.hive.$internal.jodd.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationDataReader<A extends Annotation, D extends AnnotationData<A>> {
    protected final Annotation defaultAnnotation;
    protected final Class<A> annotationClass;

    protected AnnotationDataReader(Class<A> annotationClass, Class<? extends Annotation> defaultAnnotationClass) {
        if (annotationClass == null) {
            Class[] genericSupertypes = ReflectUtil.getGenericSupertypes(this.getClass());
            if (genericSupertypes != null) {
                annotationClass = genericSupertypes[0];
            }
            if (annotationClass == null || annotationClass == Annotation.class) {
                throw new IllegalArgumentException("Missing annotation from generics supertype");
            }
        }
        this.annotationClass = annotationClass;
        if (defaultAnnotationClass != null && defaultAnnotationClass != annotationClass) {
            Annotation defaultAnnotation = annotationClass.getAnnotation(defaultAnnotationClass);
            if (defaultAnnotation == null) {
                try {
                    defaultAnnotation = defaultAnnotationClass.newInstance();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            this.defaultAnnotation = defaultAnnotation;
        } else {
            this.defaultAnnotation = null;
        }
    }

    public Class<A> getAnnotationClass() {
        return this.annotationClass;
    }

    public boolean hasAnnotation(AccessibleObject accessibleObject) {
        return accessibleObject.isAnnotationPresent(this.annotationClass);
    }

    public D readAnnotationData(AccessibleObject accessibleObject) {
        A annotation = accessibleObject.getAnnotation(this.annotationClass);
        if (annotation == null) {
            return null;
        }
        return this.createAnnotationData(annotation);
    }

    protected abstract D createAnnotationData(A var1);

    protected String readStringElement(A annotation, String name) {
        Object annotationValue = ReflectUtil.readAnnotationValue(annotation, name);
        if (annotationValue == null) {
            if (this.defaultAnnotation == null) {
                return null;
            }
            annotationValue = ReflectUtil.readAnnotationValue(this.defaultAnnotation, name);
            if (annotationValue == null) {
                return null;
            }
        }
        String value = Convert.toString(annotationValue);
        return value.trim();
    }

    protected Object readElement(A annotation, String name) {
        Object annotationValue = ReflectUtil.readAnnotationValue(annotation, name);
        if (annotationValue == null && this.defaultAnnotation != null) {
            annotationValue = ReflectUtil.readAnnotationValue(this.defaultAnnotation, name);
        }
        return annotationValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AnnotationData<N extends Annotation> {
        protected final N annotation;

        protected AnnotationData(N annotation) {
            this.annotation = annotation;
        }

        public N getAnnotation() {
            return this.annotation;
        }
    }
}

