/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OrcStruct;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LazyStructTreeReader
extends LazyTreeReader {
    private final LazyTreeReader[] fields;
    private final List<String> fieldNames;

    public LazyStructTreeReader(int columnId, long rowIndexStride, LazyTreeReader[] fields, List<String> fieldNames) throws IOException {
        super(columnId, rowIndexStride);
        this.fields = fields;
        this.fieldNames = fieldNames;
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        for (LazyTreeReader field : this.fields) {
            if (field == null) continue;
            field.skipRowsInComplexType(numNonNullValues);
        }
    }

    @Override
    public Object next(Object previous) throws IOException {
        OrcStruct result = null;
        if (this.valuePresent) {
            if (previous == null) {
                result = new OrcStruct(this.fieldNames);
            } else {
                result = (OrcStruct)previous;
                result.setFieldNames(this.fieldNames);
            }
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == null) continue;
                result.setFieldValue(i, this.fields[i].getInComplexType(result.getFieldValue(i), this.previousRow));
            }
        }
        return result;
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i] == null) continue;
            this.fields[i].startStripe(streams, encodings, indexes, rowBaseInStripe);
        }
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    protected void seek(int rowIndexEntry, boolean backwards) throws IOException {
        super.seek(rowIndexEntry, backwards);
        for (LazyTreeReader field : this.fields) {
            if (field == null) continue;
            field.seek(rowIndexEntry, backwards);
        }
    }

    @Override
    protected void seek(int index) throws IOException {
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (LazyTreeReader field : this.fields) {
            if (field == null) continue;
            field.close();
        }
    }
}

