/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hadoop.HadoopFileStatus;
import com.facebook.presto.hive.ConcurrentLazyQueue;
import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HivePartitionMetadata;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveSplitSource;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.UnpartitionedPartition;
import com.facebook.presto.hive.util.HiveFileIterator;
import com.facebook.presto.hive.util.ResumableTask;
import com.facebook.presto.hive.util.ResumableTasks;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.TupleDomain;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    public static final CompletableFuture<?> COMPLETED_FUTURE = CompletableFuture.completedFuture(null);
    private final String connectorId;
    private final Table table;
    private final Optional<HiveBucketing.HiveBucket> bucket;
    private final HdfsEnvironment hdfsEnvironment;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final DataSize maxSplitSize;
    private final int maxPartitionBatchSize;
    private final DataSize maxInitialSplitSize;
    private final boolean recursiveDirWalkerEnabled;
    private final Executor executor;
    private final ConnectorSession session;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<HiveFileIterator> fileIterators = new ConcurrentLinkedDeque<HiveFileIterator>();
    private final AtomicInteger remainingInitialSplits;
    private final ReentrantReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private volatile boolean stopped;

    public BackgroundHiveSplitLoader(String connectorId, Table table, Iterable<HivePartitionMetadata> partitions, Optional<HiveBucketing.HiveBucket> bucket, DataSize maxSplitSize, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int maxPartitionBatchSize, DataSize maxInitialSplitSize, int maxInitialSplits, boolean recursiveDirWalkerEnabled) {
        this.connectorId = connectorId;
        this.table = table;
        this.bucket = bucket;
        this.maxSplitSize = maxSplitSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.session = session;
        this.hdfsEnvironment = hdfsEnvironment;
        this.namenodeStats = namenodeStats;
        this.directoryLister = directoryLister;
        this.maxInitialSplitSize = maxInitialSplitSize;
        this.remainingInitialSplits = new AtomicInteger(maxInitialSplits);
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.executor = executor;
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(partitions);
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        for (int i = 0; i < this.maxPartitionBatchSize; ++i) {
            ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeFinishedIfNecessary() {
        if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
            this.taskExecutionLock.writeLock().lock();
            try {
                if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                    this.hiveSplitSource.finished();
                }
            }
            finally {
                this.taskExecutionLock.writeLock().unlock();
            }
        }
    }

    private CompletableFuture<?> loadSplits() throws IOException {
        HiveFileIterator files = this.fileIterators.poll();
        if (files == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            this.loadPartition(partition);
            return COMPLETED_FUTURE;
        }
        while (files.hasNext() && !this.stopped) {
            LocatedFileStatus file = (LocatedFileStatus)files.next();
            if (HadoopFileStatus.isDirectory((FileStatus)file)) {
                if (!this.recursiveDirWalkerEnabled) continue;
                HiveFileIterator fileIterator = new HiveFileIterator(file.getPath(), files.getFileSystem(), files.getDirectoryLister(), files.getNamenodeStats(), files.getPartitionName(), files.getInputFormat(), files.getSchema(), files.getPartitionKeys(), files.getEffectivePredicate());
                this.fileIterators.add(fileIterator);
                continue;
            }
            boolean splittable = HiveUtil.isSplittable(files.getInputFormat(), this.hdfsEnvironment.getFileSystem(file.getPath()), file.getPath());
            CompletableFuture<?> future = this.hiveSplitSource.addToQueue(this.createHiveSplits(files.getPartitionName(), file.getPath().toString(), file.getBlockLocations(), 0L, file.getLen(), files.getSchema(), files.getPartitionKeys(), splittable, this.session, files.getEffectivePredicate()));
            if (future.isDone()) continue;
            this.fileIterators.addFirst(files);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private void loadPartition(HivePartitionMetadata partition) throws IOException {
        Optional<FileStatus> bucketFile;
        String partitionName = partition.getHivePartition().getPartitionId();
        Properties schema = BackgroundHiveSplitLoader.getPartitionSchema(this.table, partition.getPartition());
        List<HivePartitionKey> partitionKeys = BackgroundHiveSplitLoader.getPartitionKeys(this.table, partition.getPartition());
        TupleDomain<HiveColumnHandle> effectivePredicate = partition.getHivePartition().getEffectivePredicate();
        Path path = new Path(BackgroundHiveSplitLoader.getPartitionLocation(this.table, partition.getPartition()));
        Configuration configuration = this.hdfsEnvironment.getConfiguration(path);
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(configuration, schema, false);
        if (inputFormat instanceof SymlinkTextInputFormat) {
            InputSplit[] splits;
            JobConf jobConf = new JobConf(configuration);
            FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])new Path[]{path});
            for (InputSplit rawSplit : splits = inputFormat.getSplits(jobConf, 0)) {
                FileSplit split = ((SymlinkTextInputFormat.SymlinkTextInputSplit)rawSplit).getTargetSplit();
                FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(split.getPath());
                FileStatus file = targetFilesystem.getFileStatus(split.getPath());
                this.hiveSplitSource.addToQueue(this.createHiveSplits(partitionName, file.getPath().toString(), targetFilesystem.getFileBlockLocations(file, split.getStart(), split.getLength()), split.getStart(), split.getLength(), schema, partitionKeys, false, this.session, effectivePredicate));
                if (!this.stopped) continue;
                return;
            }
            return;
        }
        FileSystem fs = this.hdfsEnvironment.getFileSystem(path);
        if (this.bucket.isPresent() && (bucketFile = BackgroundHiveSplitLoader.getBucketFile(this.bucket.get(), fs, path)).isPresent()) {
            FileStatus file = bucketFile.get();
            BlockLocation[] blockLocations = fs.getFileBlockLocations(file, 0L, file.getLen());
            boolean splittable = HiveUtil.isSplittable(inputFormat, fs, file.getPath());
            this.hiveSplitSource.addToQueue(this.createHiveSplits(partitionName, file.getPath().toString(), blockLocations, 0L, file.getLen(), schema, partitionKeys, splittable, this.session, effectivePredicate));
            return;
        }
        HiveFileIterator iterator = new HiveFileIterator(path, fs, this.directoryLister, this.namenodeStats, partitionName, inputFormat, schema, partitionKeys, effectivePredicate);
        this.fileIterators.addLast(iterator);
    }

    private static Optional<FileStatus> getBucketFile(HiveBucketing.HiveBucket bucket, FileSystem fs, Path path) {
        FileStatus[] statuses = BackgroundHiveSplitLoader.listStatus(fs, path);
        if (statuses.length != bucket.getBucketCount()) {
            return Optional.empty();
        }
        HashMap<String, FileStatus> map = new HashMap<String, FileStatus>();
        ArrayList<String> paths = new ArrayList<String>();
        for (FileStatus status : statuses) {
            if (!HadoopFileStatus.isFile((FileStatus)status)) {
                return Optional.empty();
            }
            String pathString = status.getPath().toString();
            map.put(pathString, status);
            paths.add(pathString);
        }
        Collections.sort(paths);
        String pathString = (String)paths.get(bucket.getBucketNumber());
        return Optional.of(map.get(pathString));
    }

    private static FileStatus[] listStatus(FileSystem fs, Path path) {
        try {
            return fs.listStatus(path);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private List<HiveSplit> createHiveSplits(String partitionName, String path, BlockLocation[] blockLocations, long start, long length, Properties schema, List<HivePartitionKey> partitionKeys, boolean splittable, ConnectorSession session, TupleDomain<HiveColumnHandle> effectivePredicate) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean forceLocalScheduling = HiveSessionProperties.isForceLocalScheduling(session);
        if (splittable) {
            for (BlockLocation blockLocation : blockLocations) {
                long chunkOffset;
                long chunkLength;
                List<HostAddress> addresses = BackgroundHiveSplitLoader.toHostAddress(blockLocation.getHosts());
                long maxBytes = this.maxSplitSize.toBytes();
                if (this.remainingInitialSplits.get() > 0) {
                    maxBytes = this.maxInitialSplitSize.toBytes();
                }
                int chunks = Math.max(1, (int)(blockLocation.getLength() / maxBytes));
                long targetChunkSize = (long)Math.ceil((double)blockLocation.getLength() * 1.0 / (double)chunks);
                for (chunkOffset = 0L; chunkOffset < blockLocation.getLength(); chunkOffset += chunkLength) {
                    chunkLength = Math.min(targetChunkSize, blockLocation.getLength() - chunkOffset);
                    builder.add((Object)new HiveSplit(this.connectorId, this.table.getDbName(), this.table.getTableName(), partitionName, path, blockLocation.getOffset() + chunkOffset, chunkLength, schema, partitionKeys, addresses, forceLocalScheduling, effectivePredicate));
                    this.remainingInitialSplits.decrementAndGet();
                }
                Preconditions.checkState((chunkOffset == blockLocation.getLength() ? 1 : 0) != 0, (Object)"Error splitting blocks");
            }
        } else {
            Object addresses = ImmutableList.of();
            if (blockLocations.length > 0) {
                addresses = BackgroundHiveSplitLoader.toHostAddress(blockLocations[0].getHosts());
            }
            builder.add((Object)new HiveSplit(this.connectorId, this.table.getDbName(), this.table.getTableName(), partitionName, path, start, length, schema, partitionKeys, (List<HostAddress>)addresses, forceLocalScheduling, effectivePredicate));
        }
        return builder.build();
    }

    private static List<HostAddress> toHostAddress(String[] hosts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String host : hosts) {
            builder.add((Object)HostAddress.fromString((String)host));
        }
        return builder.build();
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Partition partition) {
        if (UnpartitionedPartition.isUnpartitioned(partition)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List keys = table.getPartitionKeys();
        List values = partition.getValues();
        HiveUtil.checkCondition(keys.size() == values.size(), HiveErrorCode.HIVE_INVALID_METADATA, "Expected %s partition key values, but got %s", keys.size(), values.size());
        for (int i = 0; i < keys.size(); ++i) {
            String name = ((FieldSchema)keys.get(i)).getName();
            HiveType hiveType = HiveType.getSupportedHiveType(((FieldSchema)keys.get(i)).getType());
            String value = (String)values.get(i);
            HiveUtil.checkCondition(value != null, HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "partition key value cannot be null for field: %s", name);
            partitionKeys.add((Object)new HivePartitionKey(name, hiveType, value));
        }
        return partitionKeys.build();
    }

    private static Properties getPartitionSchema(Table table, Partition partition) {
        if (UnpartitionedPartition.isUnpartitioned(partition)) {
            return MetaStoreUtils.getTableMetadata((Table)table);
        }
        return MetaStoreUtils.getSchema((Partition)partition, (Table)table);
    }

    private static String getPartitionLocation(Table table, Partition partition) {
        if (UnpartitionedPartition.isUnpartitioned(partition)) {
            return table.getSd().getLocation();
        }
        return partition.getSd().getLocation();
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        @Override
        public ResumableTask.TaskStatus process() {
            while (!BackgroundHiveSplitLoader.this.stopped) {
                try {
                    CompletableFuture future;
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                    try {
                        future = BackgroundHiveSplitLoader.this.loadSplits();
                    }
                    finally {
                        BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                    }
                    BackgroundHiveSplitLoader.this.invokeFinishedIfNecessary();
                    if (future.isDone()) continue;
                    return ResumableTask.TaskStatus.continueOn(future);
                }
                catch (Exception e) {
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e);
                    continue;
                }
                break;
            }
            return ResumableTask.TaskStatus.finished();
        }
    }
}

