/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.hive.PrestoS3FileSystem;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.SocksSocketFactory;

public class HdfsConfigurationUpdater {
    private final HostAndPort socksProxy;
    private final Duration dfsTimeout;
    private final Duration dfsConnectTimeout;
    private final int dfsConnectMaxRetries;
    private final String domainSocketPath;
    private final String s3AwsAccessKey;
    private final String s3AwsSecretKey;
    private final boolean s3UseInstanceCredentials;
    private final boolean s3SslEnabled;
    private final int s3MaxClientRetries;
    private final int s3MaxErrorRetries;
    private final Duration s3MaxBackoffTime;
    private final Duration s3MaxRetryTime;
    private final Duration s3ConnectTimeout;
    private final Duration s3SocketTimeout;
    private final int s3MaxConnections;
    private final DataSize s3MultipartMinFileSize;
    private final DataSize s3MultipartMinPartSize;
    private final File s3StagingDirectory;
    private final List<String> resourcePaths;

    @Inject
    public HdfsConfigurationUpdater(HiveClientConfig hiveClientConfig) {
        Preconditions.checkNotNull((Object)hiveClientConfig, (Object)"hiveClientConfig is null");
        Preconditions.checkArgument((hiveClientConfig.getDfsTimeout().toMillis() >= 1L ? 1 : 0) != 0, (Object)"dfsTimeout must be at least 1 ms");
        this.socksProxy = hiveClientConfig.getMetastoreSocksProxy();
        this.dfsTimeout = hiveClientConfig.getDfsTimeout();
        this.dfsConnectTimeout = hiveClientConfig.getDfsConnectTimeout();
        this.dfsConnectMaxRetries = hiveClientConfig.getDfsConnectMaxRetries();
        this.domainSocketPath = hiveClientConfig.getDomainSocketPath();
        this.s3AwsAccessKey = hiveClientConfig.getS3AwsAccessKey();
        this.s3AwsSecretKey = hiveClientConfig.getS3AwsSecretKey();
        this.s3UseInstanceCredentials = hiveClientConfig.isS3UseInstanceCredentials();
        this.s3SslEnabled = hiveClientConfig.isS3SslEnabled();
        this.s3MaxClientRetries = hiveClientConfig.getS3MaxClientRetries();
        this.s3MaxErrorRetries = hiveClientConfig.getS3MaxErrorRetries();
        this.s3MaxBackoffTime = hiveClientConfig.getS3MaxBackoffTime();
        this.s3MaxRetryTime = hiveClientConfig.getS3MaxRetryTime();
        this.s3ConnectTimeout = hiveClientConfig.getS3ConnectTimeout();
        this.s3SocketTimeout = hiveClientConfig.getS3SocketTimeout();
        this.s3MaxConnections = hiveClientConfig.getS3MaxConnections();
        this.s3MultipartMinFileSize = hiveClientConfig.getS3MultipartMinFileSize();
        this.s3MultipartMinPartSize = hiveClientConfig.getS3MultipartMinPartSize();
        this.s3StagingDirectory = hiveClientConfig.getS3StagingDirectory();
        this.resourcePaths = hiveClientConfig.getResourceConfigFiles();
    }

    public void updateConfiguration(Configuration config) {
        if (this.resourcePaths != null) {
            for (String resourcePath : this.resourcePaths) {
                config.addResource(new Path(resourcePath));
            }
        }
        config.setClass("topology.node.switch.mapping.impl", NoOpDNSToSwitchMapping.class, DNSToSwitchMapping.class);
        if (this.socksProxy != null) {
            config.setClass("hadoop.rpc.socket.factory.class.default", SocksSocketFactory.class, SocketFactory.class);
            config.set("hadoop.socks.server", this.socksProxy.toString());
        }
        if (this.domainSocketPath != null) {
            config.setStrings("dfs.domain.socket.path", new String[]{this.domainSocketPath});
        }
        if (!config.get("dfs.domain.socket.path", "").trim().isEmpty()) {
            config.setBooleanIfUnset("dfs.client.read.shortcircuit", true);
        }
        config.setInt("dfs.socket.timeout", Ints.checkedCast((long)this.dfsTimeout.toMillis()));
        config.setInt("ipc.ping.interval", Ints.checkedCast((long)this.dfsTimeout.toMillis()));
        config.setInt("ipc.client.connect.timeout", Ints.checkedCast((long)this.dfsConnectTimeout.toMillis()));
        config.setInt("ipc.client.connect.max.retries", this.dfsConnectMaxRetries);
        config.set("fs.s3.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3a.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3n.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3bfs.impl", "org.apache.hadoop.fs.s3.S3FileSystem");
        for (String scheme : ImmutableList.of((Object)"s3", (Object)"s3a", (Object)"s3bfs", (Object)"s3n")) {
            if (this.s3AwsAccessKey != null) {
                config.set(String.format("fs.%s.awsAccessKeyId", scheme), this.s3AwsAccessKey);
            }
            if (this.s3AwsSecretKey == null) continue;
            config.set(String.format("fs.%s.awsSecretAccessKey", scheme), this.s3AwsSecretKey);
        }
        config.setBoolean("presto.s3.use-instance-credentials", this.s3UseInstanceCredentials);
        config.setBoolean("presto.s3.ssl.enabled", this.s3SslEnabled);
        config.setInt("presto.s3.max-client-retries", this.s3MaxClientRetries);
        config.setInt("presto.s3.max-error-retries", this.s3MaxErrorRetries);
        config.set("presto.s3.max-backoff-time", this.s3MaxBackoffTime.toString());
        config.set("presto.s3.max-retry-time", this.s3MaxRetryTime.toString());
        config.set("presto.s3.connect-timeout", this.s3ConnectTimeout.toString());
        config.set("presto.s3.socket-timeout", this.s3SocketTimeout.toString());
        config.set("presto.s3.staging-directory", this.s3StagingDirectory.toString());
        config.setInt("presto.s3.max-connections", this.s3MaxConnections);
        config.setLong("presto.s3.multipart.min-file-size", this.s3MultipartMinFileSize.toBytes());
        config.setLong("presto.s3.multipart.min-part-size", this.s3MultipartMinPartSize.toBytes());
    }

    public static class NoOpDNSToSwitchMapping
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> names) {
            return ImmutableList.of();
        }

        public void reloadCachedMappings() {
        }
    }
}

